/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.osgi;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.packagedrone.repo.aspect.ChannelAspect;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectFactory;
import org.eclipse.packagedrone.repo.aspect.listener.ChannelListener;
import org.eclipse.packagedrone.repo.channel.PreAddContext;

public class TychoCleanerFactory
implements ChannelAspectFactory {
    private static final String ID = "tycho-cleaner";
    private static List<Pattern> ignoredPatterns = new LinkedList<Pattern>();

    static {
        ignoredPatterns.add(Pattern.compile(".*-p2content.xml$"));
        ignoredPatterns.add(Pattern.compile(".*-p2artifacts.xml$"));
        ignoredPatterns.add(Pattern.compile(".*-p2metadata.xml$"));
    }

    public ChannelAspect createAspect() {
        return new ChannelAspect(){

            public String getId() {
                return TychoCleanerFactory.ID;
            }

            public ChannelListener getChannelListener() {
                return new ChannelListener(){

                    public void artifactPreAdd(PreAddContext context) {
                        if (!context.isExternal()) {
                            return;
                        }
                        String name = context.getName();
                        for (Pattern pattern : ignoredPatterns) {
                            if (!pattern.matcher(name).matches()) continue;
                            context.vetoAdd();
                            return;
                        }
                    }
                };
            }
        };
    }
}

