/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.utils;

import com.google.common.net.UrlEscapers;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.common.CommonController;

public final class Channels {
    private Channels() {
    }

    public static <T> ModelAndView withChannel(ChannelService service, String channelId, Class<T> clazz, ChannelService.ChannelOperation<ModelAndView, T> operation) {
        Objects.requireNonNull(service, "'service' must not be null");
        try {
            return (ModelAndView)service.accessCall(ChannelService.By.id((String)channelId), clazz, operation);
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
    }

    public static <T extends ReadableChannel> ModelAndView withArtifact(ChannelService service, String channelId, String artifactId, Class<T> clazz, ArtifactOperation<T> operation) {
        return Channels.withChannel(service, channelId, clazz, channel -> {
            Optional artifact = channel.getArtifact(artifactId);
            if (!artifact.isPresent()) {
                return CommonController.createNotFound((String)"artifact", (String)artifactId);
            }
            return operation.process(channel, (ChannelArtifactInformation)artifact.get());
        });
    }

    public static ModelAndView redirectViewArtifact(ChannelArtifactInformation artifact) {
        return Channels.redirectViewArtifact(artifact.getChannelId().getId(), artifact.getId());
    }

    public static ModelAndView redirectViewArtifact(String channelId, String artifactId) {
        return new ModelAndView("redirect:/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(channelId) + "/artifacts/" + UrlEscapers.urlPathSegmentEscaper().escape(artifactId) + "/view");
    }

    public static ModelAndView redirectViewChannel(ChannelId channel) {
        return Channels.redirectViewChannel(channel.getId());
    }

    public static ModelAndView redirectViewChannel(String channelId) {
        return new ModelAndView("redirect:" + Channels.channelTarget(channelId));
    }

    public static String channelTarget(String channelId) {
        return "/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(channelId) + "/view";
    }

    @FunctionalInterface
    public static interface ArtifactOperation<T extends ReadableChannel> {
        public ModelAndView process(T var1, ChannelArtifactInformation var2) throws Exception;
    }
}

