/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.upload;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Coordinates {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String qualifiedVersion;
    private final String classifier;
    private final String extension;

    public Coordinates(String groupId, String artifactId, String version, String extension) {
        this(groupId, artifactId, version, version, null, extension);
    }

    public Coordinates(String groupId, String artifactId, String version, String classifier, String extension) {
        this(groupId, artifactId, version, version, classifier, extension);
    }

    public Coordinates(String groupId, String artifactId, String version, String qualifiedVersion, String classifier, String extension) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.qualifiedVersion = qualifiedVersion;
        this.classifier = classifier;
        this.extension = extension;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getQualifiedVersion() {
        return this.qualifiedVersion;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.qualifiedVersion == null ? 0 : this.qualifiedVersion.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.qualifiedVersion == null ? other.qualifiedVersion != null : !this.qualifiedVersion.equals(other.qualifiedVersion)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return this.toFullPath();
    }

    public String toFullPath() {
        StringBuilder sb = new StringBuilder();
        this.appendFullPath(sb);
        return sb.toString();
    }

    public String toFileName() {
        StringBuilder sb = new StringBuilder();
        this.appendFileName(sb);
        return sb.toString();
    }

    public static String makePath(String groupId, String artifactId, String version, String qualifiedVersion, String classifier, String extension) {
        return new Coordinates(groupId, artifactId, version, qualifiedVersion, classifier, extension).toFullPath();
    }

    public void appendFullPath(StringBuilder sb) {
        sb.append('/');
        sb.append(this.groupId.replace('.', '/'));
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('/');
        sb.append(this.version);
        sb.append('/');
        this.appendFileName(sb);
    }

    public void appendFileName(StringBuilder sb) {
        sb.append(this.artifactId).append('-').append(this.qualifiedVersion == null ? this.version : this.qualifiedVersion);
        if (this.classifier != null) {
            sb.append('-').append(this.classifier);
        }
        sb.append('.').append(this.extension);
    }

    public static Coordinates parse(String path) {
        LinkedList<String> toks = new LinkedList<String>(Arrays.asList(path.split("/")));
        String fileName = toks.pollLast();
        String version = toks.pollLast();
        String artifactId = toks.pollLast();
        StringBuilder sb = new StringBuilder();
        for (String tok : toks) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(tok);
        }
        String groupId = sb.toString();
        String[] stringArray = Coordinates.makeExpectedVersions(version);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedVersion = stringArray[n2];
            String[] split = Coordinates.extractInformation(artifactId, expectedVersion, fileName);
            if (split != null) {
                return new Coordinates(groupId, artifactId, version, split[0], split[1], split[2]);
            }
            ++n2;
        }
        return null;
    }

    public static boolean isSnapshot(String version) {
        return version.endsWith(SNAPSHOT_SUFFIX);
    }

    private static String[] makeExpectedVersions(String version) {
        if (!Coordinates.isSnapshot(version)) {
            return new String[]{Pattern.quote(version)};
        }
        String baseVersion = version.substring(0, version.length() - SNAPSHOT_SUFFIX.length());
        return new String[]{Pattern.quote(version), String.valueOf(Pattern.quote(baseVersion)) + "-\\d{8}\\.\\d{6}-\\d+"};
    }

    private static String[] extractInformation(String artifactId, String expectedVersionPattern, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(Pattern.quote(artifactId));
        sb.append("-");
        sb.append("(?<v>" + expectedVersionPattern + ")");
        sb.append("(|-(?<cl>[^\\.]+))");
        sb.append("(|\\.(?<ext>.*+))");
        Pattern p = Pattern.compile(sb.toString());
        Matcher m = p.matcher(name);
        if (m.matches()) {
            String version = m.group("v");
            String classifier = m.group("cl");
            String extension = m.group("ext");
            return new String[]{version, classifier, extension};
        }
        return null;
    }

    public Coordinates makeUnclassified() {
        if (this.classifier == null) {
            return this;
        }
        return new Coordinates(this.groupId, this.artifactId, this.version, this.qualifiedVersion, null, this.extension);
    }

    public Coordinates replaceExtension(String newExtension) {
        return new Coordinates(this.groupId, this.artifactId, this.version, this.qualifiedVersion, this.classifier, newExtension);
    }
}

