/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.transfer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.packagedrone.utils.io.Streams;

@FunctionalInterface
public interface ContentProvider {
    public void provide(OutputStream var1) throws IOException;

    public static ContentProvider string(String value) {
        return stream -> stream.write(value.getBytes(StandardCharsets.UTF_8));
    }

    public static ContentProvider data(byte[] value) {
        return stream -> stream.write(value);
    }

    public static ContentProvider file(Path path) {
        return stream -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                Streams.copy((InputStream)input, (OutputStream)stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
    }

    public static ContentProvider file(File file) {
        return ContentProvider.file(file.toPath());
    }
}

