/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.ViewResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAndViewRequestHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(ModelAndViewRequestHandler.class);
    private final ModelAndView modelAndView;
    private final Class<?> controllerClazz;
    private final Method method;

    public ModelAndViewRequestHandler(ModelAndView modelAndView, Class<?> controllerClazz, Method method) {
        this.modelAndView = modelAndView;
        this.controllerClazz = controllerClazz;
        this.method = method;
    }

    public ModelAndView getModelAndView() {
        return this.modelAndView;
    }

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String redir = this.modelAndView.getRedirect();
        if (redir != null) {
            logger.debug("Processed redirect: {}", (Object)redir);
            response.sendRedirect(redir);
            return;
        }
        if (this.modelAndView.isReferer()) {
            URL url;
            String path;
            String ref = request.getHeader("Referer");
            if (ref == null) {
                response.sendRedirect(this.modelAndView.getReferer());
            }
            if ((path = (url = new URL(ref)).getPath()).startsWith(request.getContextPath())) {
                path = path.substring(request.getContextPath().length());
            }
            response.sendRedirect(path);
            return;
        }
        ViewResolver viewResolver = null;
        Class<?> resourceClazz = this.controllerClazz;
        if (this.modelAndView.getAlternateViewResolver() != null) {
            viewResolver = this.modelAndView.getAlternateViewResolver().getAnnotation(ViewResolver.class);
            resourceClazz = this.modelAndView.getAlternateViewResolver();
        }
        if (viewResolver == null && this.method != null) {
            viewResolver = this.method.getAnnotation(ViewResolver.class);
        }
        if (viewResolver == null && this.controllerClazz != null) {
            viewResolver = this.controllerClazz.getAnnotation(ViewResolver.class);
        }
        if (viewResolver == null) {
            throw new IllegalStateException(String.format("View resolver for %s not declared. Missing @%s annotation?", this.controllerClazz.getName(), ViewResolver.class.getSimpleName()));
        }
        Bundle bundle = FrameworkUtil.getBundle(resourceClazz);
        StringBuilder pathBuilder = new StringBuilder("/bundle/");
        pathBuilder.append(bundle.getBundleId());
        String fullViewName = String.format(viewResolver.value(), this.modelAndView.getViewName());
        if (!fullViewName.startsWith("/")) {
            pathBuilder.append('/');
        }
        pathBuilder.append(fullViewName);
        String path = ModelAndViewRequestHandler.normalize(pathBuilder.toString());
        logger.debug("Render: {}", (Object)path);
        this.setModelAsRequestAttributes(request, this.modelAndView.getModel());
        Throwable throwable = null;
        Object var11_15 = null;
        try (Profile.Handle handle = Profile.start((String)("render:" + this.modelAndView.getViewName()));){
            this.render(request, response, path);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String normalize(String string) {
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        boolean slash = false;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '/') {
                if (!slash) {
                    slash = true;
                    sb.append(c);
                }
            } else {
                sb.append(c);
                slash = false;
            }
            ++i;
        }
        return sb.toString();
    }

    private void render(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (response.isCommitted()) {
            logger.trace("Including");
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            logger.trace("Forwarding");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void setModelAsRequestAttributes(HttpServletRequest request, Map<String, Object> model) {
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return String.format("[RequestHandler/ModelAndView - %s]", this.modelAndView);
    }
}

