/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.apm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.utils.Tokens;
import org.eclipse.packagedrone.sec.CreateUser;
import org.eclipse.packagedrone.sec.DatabaseDetails;
import org.eclipse.packagedrone.sec.DatabaseUserInformation;
import org.eclipse.packagedrone.sec.UserDetails;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.UserStorage;
import org.eclipse.packagedrone.sec.service.LoginException;
import org.eclipse.packagedrone.sec.service.UserService;
import org.eclipse.packagedrone.sec.service.apm.Helper;
import org.eclipse.packagedrone.sec.service.apm.model.UserEntity;
import org.eclipse.packagedrone.sec.service.apm.model.UserModel;
import org.eclipse.packagedrone.sec.service.apm.model.UserStorageModelProvider;
import org.eclipse.packagedrone.sec.service.apm.model.UserWriteModel;
import org.eclipse.packagedrone.sec.service.common.SecurityMailService;
import org.eclipse.packagedrone.sec.service.common.Users;
import org.eclipse.packagedrone.sec.service.password.BadPasswordException;
import org.eclipse.packagedrone.sec.service.password.PasswordChecker;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;
import org.eclipse.packagedrone.utils.scheduler.ScheduledTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUserService
implements UserService,
UserStorage,
ScheduledTask {
    private static final MetaKey MODEL_KEY = new MetaKey("sec", "users");
    private static final Logger logger = LoggerFactory.getLogger(DatabaseUserService.class);
    private static final long MIN_EMAIL_DELAY = TimeUnit.MINUTES.toMillis(5L);
    private static final Comparator<DatabaseUserInformation> USER_COMPARATOR;
    private PasswordChecker passwordChecker;
    private SecurityMailService mailService;
    private StorageManager storageManager;
    private StorageRegistration handle;

    static {
        Comparator<DatabaseUserInformation> result = Comparator.comparing(DatabaseUserInformation::getDetails, Comparator.nullsFirst(Comparator.comparing(DatabaseDetails::getEmail)));
        result = result.thenComparing(Comparator.comparing(UserInformation::getId));
        USER_COMPARATOR = result;
    }

    public void setSecurityMailService(SecurityMailService mailService) {
        this.mailService = mailService;
    }

    public void setPasswordChecker(PasswordChecker passwordChecker) {
        this.passwordChecker = passwordChecker;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public void start() {
        this.handle = this.storageManager.registerModel(1000L, MODEL_KEY, (StorageModelProvider)new UserStorageModelProvider());
    }

    public void stop() {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
    }

    public List<DatabaseUserInformation> list(int position, int size) {
        return (List)this.storageManager.accessCall(MODEL_KEY, UserModel.class, users -> {
            ArrayList<DatabaseUserInformation> list = new ArrayList<DatabaseUserInformation>(users.listAll());
            Collections.sort(list, USER_COMPARATOR);
            int end = Math.min(position + size, list.size());
            return list.subList(position, end);
        });
    }

    public DatabaseUserInformation createUser(CreateUser data, boolean emailVerified) {
        return (DatabaseUserInformation)this.storageManager.modifyCall(MODEL_KEY, UserWriteModel.class, users -> {
            String token;
            if (!emailVerified) {
                this.checkPassword(data.getPassword());
            }
            if (data.getEmail() != null && users.findByEmail(data.getEmail()).isPresent()) {
                throw new IllegalArgumentException(String.format("A user with the e-mail '%s' already exists.", data.getEmail()));
            }
            Date now = new Date();
            UserEntity user = new UserEntity();
            user.setId(UUID.randomUUID().toString());
            user.setEmail(data.getEmail());
            user.setName(data.getName());
            user.setRegistrationDate(now);
            user.setLocked(false);
            this.applyPassword(user, data.getPassword());
            if (emailVerified) {
                token = null;
                user.setEmailVerified(true);
            } else {
                user.setEmailVerified(false);
                token = this.applyNewEmailToken(now, user);
            }
            if (token != null) {
                this.mailService.sendVerifyEmail(data.getEmail(), user.getId(), token);
            }
            users.putUser(user);
            return new DatabaseUserInformation(user.getId(), null, user.getRoles(), Helper.toDetails(user));
        });
    }

    public DatabaseUserInformation getUserDetails(String userId) {
        return (DatabaseUserInformation)this.storageManager.accessCall(MODEL_KEY, UserModel.class, users -> users.getUser(userId).orElse(null));
    }

    public DatabaseUserInformation updateUser(String userId, UserDetails data) {
        return (DatabaseUserInformation)this.storageManager.modifyCall(MODEL_KEY, UserWriteModel.class, users -> {
            UserEntity user = users.getCheckedUser(userId);
            user.setEmail(data.getEmail());
            user.setName(data.getName());
            user.setRoles(new HashSet<String>(data.getRoles()));
            users.putUser(user);
            return new DatabaseUserInformation(userId, null, (Set)data.getRoles(), Helper.toDetails(user));
        });
    }

    public String verifyEmail(String userId, String token) {
        return (String)this.storageManager.modifyCall(MODEL_KEY, UserWriteModel.class, users -> {
            UserEntity user = users.getUser(userId).orElse(null);
            if (user == null) {
                return "User not found";
            }
            if (user.isLocked()) {
                return "User is locked";
            }
            if (user.getEmailToken() == null || user.isEmailVerified()) {
                return null;
            }
            String salt = user.getEmailTokenSalt();
            String hashedToken = Users.hashIt((String)salt, (String)token);
            if (hashedToken.equals(user.getEmailToken())) {
                user.setEmailVerified(true);
                user.setEmailToken(null);
                user.setEmailTokenSalt(null);
                user.setEmailTokenDate(null);
                users.putUser(user);
                return null;
            }
            return "It may be that you clicked on a verification link which was either expired or superseeded by another e-mail request.";
        });
    }

    public DatabaseUserInformation getUserDetailsByEmail(String email) {
        return (DatabaseUserInformation)this.storageManager.accessCall(MODEL_KEY, UserModel.class, users -> users.findUserByEmail(email).orElse(null));
    }

    public String reRequestEmail(String email) {
        return (String)this.storageManager.modifyCall(MODEL_KEY, UserWriteModel.class, users -> {
            UserEntity user = users.findByEmail(email).orElse(null);
            if (user == null) {
                return "User not found";
            }
            if (user.isLocked()) {
                return "User is locked";
            }
            if (user.getEmailToken() == null || user.isEmailVerified()) {
                return "E-Mail is already verified";
            }
            if (DatabaseUserService.isTooSoon(user.getEmailTokenDate())) {
                return MessageFormat.format("An e-mail verification was requested at {0,time}. Please wait until {1,time} before requesting the next one!", user.getEmailTokenDate(), DatabaseUserService.nextMailSlot(user.getEmailTokenDate()));
            }
            String token = this.applyNewEmailToken(new Date(), user);
            users.putUser(user);
            this.mailService.sendVerifyEmail(user.getEmail(), user.getId(), token);
            return null;
        });
    }

    public String resetPassword(String email) {
        return (String)this.storageManager.modifyCall(MODEL_KEY, UserWriteModel.class, users -> {
            UserEntity user = users.findByEmail(email).orElse(null);
            if (user == null) {
                return "No account for this e-mail address.";
            }
            if (!user.isEmailVerified()) {
                return "The e-mail address for this account is not verified.";
            }
            if (DatabaseUserService.isTooSoon(user.getEmailTokenDate())) {
                return MessageFormat.format("A password reset e-mail was requested at {0,time}. Please wait until {1,time} before requesting the next one!", user.getEmailTokenDate(), DatabaseUserService.nextMailSlot(user.getEmailTokenDate()));
            }
            if (user.isLocked()) {
                this.mailService.sendEmail(user.getEmail(), "Password reset request", "lockedUser", null);
                return null;
            }
            String resetToken = Tokens.createToken((int)64);
            String resetTokenSalt = Tokens.createToken((int)32);
            String resetTokenHash = Users.hashIt((String)resetTokenSalt, (String)resetToken);
            user.setEmailTokenSalt(resetTokenSalt);
            user.setEmailTokenDate(new Date());
            user.setEmailToken(resetTokenHash);
            users.putUser(user);
            this.mailService.sendResetEmail(email, resetToken);
            return null;
        });
    }

    public void changePassword(String email, String token, String password) {
        this.storageManager.modifyRun(MODEL_KEY, UserWriteModel.class, users -> {
            logger.debug("Process password change - email: {}, token: {}, password: {}", new Object[]{email, token, password != null ? "***" : null});
            UserEntity user = users.findByEmail(email).orElse(null);
            if (user == null) {
                throw new RuntimeException("User not found");
            }
            String salt = user.getEmailTokenSalt();
            if (salt == null) {
                throw new RuntimeException("No token");
            }
            String hashedToken = Users.hashIt((String)salt, (String)token);
            if (!hashedToken.equals(user.getEmailToken())) {
                throw new RuntimeException("Invalid token");
            }
            if (user.isLocked()) {
                throw new RuntimeException("User is locked");
            }
            this.checkPassword(password);
            this.applyPassword(user, password);
            user.setEmailToken(null);
            user.setEmailTokenDate(null);
            user.setEmailTokenSalt(null);
            users.putUser(user);
        });
    }

    public void updatePassword(String userId, String currentPassword, String newPassword) {
        logger.debug("Process password update - userId: {},  currentPassword: {},  newPassword: {}", new Object[]{userId, currentPassword != null ? "***" : null, newPassword != null ? "***" : null});
        this.storageManager.modifyRun(MODEL_KEY, UserWriteModel.class, users -> {
            String checkHash;
            UserEntity user = users.getCheckedUser(userId);
            if (user.isLocked()) {
                throw new RuntimeException("User is locked");
            }
            String currentSalt = user.getPasswordSalt();
            String currentHash = user.getPasswordHash();
            this.checkPassword(newPassword);
            if (currentPassword != null && currentSalt != null && currentHash != null && !currentHash.equals(checkHash = Users.hashIt((String)currentSalt, (String)currentPassword))) {
                throw new RuntimeException("Current password is incorrect");
            }
            this.applyPassword(user, newPassword);
            users.putUser(user);
        });
    }

    protected void setUserLocked(UserWriteModel users, String userId, boolean value) {
        UserEntity user = users.getCheckedUser(userId);
        user.setLocked(value);
        users.putUser(user);
    }

    public void lockUser(String userId) {
        this.storageManager.modifyRun(MODEL_KEY, UserWriteModel.class, users -> this.setUserLocked((UserWriteModel)users, userId, true));
    }

    public void unlockUser(String userId) {
        this.storageManager.modifyRun(MODEL_KEY, UserWriteModel.class, users -> this.setUserLocked((UserWriteModel)users, userId, false));
    }

    public void deleteUser(String userId) {
        this.storageManager.modifyRun(MODEL_KEY, UserWriteModel.class, users -> {
            boolean bl = users.removeUser(userId);
        });
    }

    public UserInformation checkCredentials(String username, String credentials, boolean rememberMe) throws LoginException {
        LoginResult result = this.loginAndRememberMe(username, credentials, rememberMe);
        if (result == null) {
            return null;
        }
        if (result.exception != null) {
            throw result.exception;
        }
        return result.userInformation;
    }

    private LoginResult loginAndRememberMe(String username, String credentials, boolean rememberMe) {
        LoginResult result = (LoginResult)this.storageManager.modifyCall(MODEL_KEY, UserWriteModel.class, users -> {
            String rememberMeToken;
            String credHash;
            String tokenHash;
            UserEntity user = users.findByEmail(username).orElse(null);
            if (user == null) {
                return null;
            }
            boolean valid = false;
            if (user.getRememberMeTokenHash() != null && user.getRememberMeTokenSalt() != null && (tokenHash = Users.hashIt((String)user.getRememberMeTokenSalt(), (String)credentials)).equals(user.getRememberMeTokenHash())) {
                valid = true;
            }
            if (user.getPasswordSalt() != null && user.getPasswordHash() != null && (credHash = Users.hashIt((String)user.getPasswordSalt(), (String)credentials)).equals(user.getPasswordHash())) {
                valid = true;
            }
            if (!valid) {
                return null;
            }
            LoginResult loginResult = new LoginResult();
            loginResult.exception = this.validateUserAfterLogin(user);
            if (rememberMe) {
                rememberMeToken = Tokens.createToken((int)128);
                String tokenSalt = Tokens.createToken((int)32);
                String tokenHash2 = Users.hashIt((String)tokenSalt, (String)rememberMeToken);
                user.setRememberMeTokenHash(tokenHash2);
                user.setRememberMeTokenSalt(tokenSalt);
                users.putUser(user);
            } else {
                rememberMeToken = null;
            }
            loginResult.userInformation = new DatabaseUserInformation(user.getId(), rememberMeToken, user.getRoles(), Helper.toDetails(user));
            return loginResult;
        });
        return result;
    }

    public UserInformation refresh(UserInformation user) {
        return this.getUserDetails(user.getId());
    }

    public boolean hasUserBase() {
        return (Boolean)this.storageManager.accessCall(MODEL_KEY, UserModel.class, users -> !users.isEmpty());
    }

    private void checkPassword(String password) {
        try {
            this.passwordChecker.checkPassword(password);
        }
        catch (BadPasswordException e) {
            throw new RuntimeException(e);
        }
    }

    private static Date nextMailSlot(Date date) {
        return new Date(date.getTime() + MIN_EMAIL_DELAY);
    }

    private static boolean isTooSoon(Date date) {
        if (date == null) {
            return false;
        }
        return System.currentTimeMillis() - date.getTime() < MIN_EMAIL_DELAY;
    }

    private void applyPassword(UserEntity user, String password) {
        if (password == null || password.isEmpty()) {
            return;
        }
        String salt = Tokens.createToken((int)32);
        String passwordHash = Users.hashIt((String)salt, (String)password);
        user.setPasswordSalt(salt);
        user.setPasswordHash(passwordHash);
    }

    protected String applyNewEmailToken(Date now, UserEntity user) {
        String token = Tokens.createToken((int)32);
        String tokenSalt = Tokens.createToken((int)32);
        String tokenHash = Users.hashIt((String)tokenSalt, (String)token);
        user.setEmailToken(tokenHash);
        user.setEmailTokenSalt(tokenSalt);
        user.setEmailTokenDate(now);
        return token;
    }

    protected LoginException validateUserAfterLogin(UserEntity user) {
        if (user.isLocked()) {
            return new LoginException("User is locked");
        }
        if (!user.isEmailVerified()) {
            return new LoginException("E-mail not verified");
        }
        return null;
    }

    public void run() throws Exception {
        this.storageManager.modifyRun(MODEL_KEY, UserWriteModel.class, users -> {
            Date timeout = new Date(System.currentTimeMillis() - this.getTimeout());
            LinkedList<UserEntity> updates = new LinkedList<UserEntity>();
            LinkedList<String> removals = new LinkedList<String>();
            for (UserEntity user : users.asCollection()) {
                if (user.getEmailTokenDate() == null || user.getEmailTokenDate().after(timeout)) continue;
                if (user.isEmailVerified()) {
                    user.setEmailToken(null);
                    user.setEmailTokenDate(null);
                    user.setEmailTokenSalt(null);
                    updates.add(user);
                    continue;
                }
                removals.add(user.getId());
            }
            updates.forEach(users::putUser);
            removals.forEach(users::removeUser);
        });
    }

    private long getTimeout() {
        return TimeUnit.HOURS.toMillis(1L);
    }

    private static class LoginResult {
        UserInformation userInformation;
        LoginException exception;

        private LoginResult() {
        }
    }
}

