/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;

public class RootApplication
extends Application {
    private final Map<String, Object> properties;
    private final List<Object> resources;
    private final Object lock = new Object();
    private volatile boolean dirty;

    public RootApplication() {
        this.resources = new LinkedList<Object>();
        this.properties = new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResource(Object resource) {
        Object object = this.lock;
        synchronized (object) {
            this.resources.add(resource);
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResource(Object resource) {
        Object object = this.lock;
        synchronized (object) {
            this.resources.remove(resource);
            this.dirty = true;
        }
    }

    boolean hasResources() {
        return !this.resources.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getSingletons() {
        Object object = this.lock;
        synchronized (object) {
            Set<Object> currentResources = this.getResources();
            this.dirty = false;
            return currentResources;
        }
    }

    public Set<Object> getResources() {
        HashSet<Object> singletons = new HashSet<Object>(super.getSingletons());
        singletons.addAll(this.resources);
        return singletons;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String key, Object value) {
        Object oldValue = this.properties.get(key);
        this.properties.put(key, value);
        Object object = this.lock;
        synchronized (object) {
            if (!(this.dirty || value == oldValue || value != null && value.equals(oldValue))) {
                this.dirty = true;
            }
        }
    }

    public void addProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            return this.dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty(boolean isDirty) {
        Object object = this.lock;
        synchronized (object) {
            this.dirty = isDirty;
        }
    }
}

