/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binding;
import org.eclipse.packagedrone.web.controller.binding.ExceptionError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBindTarget
implements BindTarget {
    private static final Logger logger = LoggerFactory.getLogger(PropertyBindTarget.class);
    private final PropertyDescriptor propertyDescriptor;
    private final Class<?> objectClass;
    private final Object target;

    public PropertyBindTarget(Object target, PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
        this.target = target;
        this.objectClass = target.getClass();
    }

    @Override
    public Class<?> getType() {
        return this.propertyDescriptor.getPropertyType();
    }

    @Override
    public String getQualifier() {
        return this.propertyDescriptor.getName();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    @Override
    public <T extends Annotation> Collection<T> getAnnotationsByType(Class<T> annotationClass) {
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        result.addAll(Arrays.asList(this.propertyDescriptor.getWriteMethod().getAnnotationsByType(annotationClass)));
        try {
            Field field = this.objectClass.getField(this.propertyDescriptor.getName());
            result.addAll(Arrays.asList(field.getAnnotationsByType(annotationClass)));
        }
        catch (Exception exception) {
            return null;
        }
        return result;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Field field;
        T a = this.propertyDescriptor.getWriteMethod().getAnnotation(clazz);
        if (a != null) {
            return a;
        }
        try {
            field = this.objectClass.getField(this.propertyDescriptor.getName());
        }
        catch (Exception exception) {
            return null;
        }
        return field.getAnnotation(clazz);
    }

    @Override
    public void bind(Binding binding) {
        try {
            this.propertyDescriptor.getWriteMethod().invoke(this.target, binding.getValue());
        }
        catch (Exception e) {
            logger.debug("Failed to apply property", (Throwable)e);
            binding.getBindingResult().addError(new ExceptionError(e));
        }
    }
}

