/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.routing;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.web.controller.routing.PathMatcher;
import org.eclipse.packagedrone.web.controller.routing.PatternPathMatcher;
import org.eclipse.packagedrone.web.controller.routing.PlainPathMatcher;
import org.eclipse.packagedrone.web.util.Requests;

public class RequestMappingInformation {
    private final PathMatcher[] paths;
    private final Set<String> methods;
    private final Set<String> rawPaths;
    private static final Pattern pp = Pattern.compile("\\{([^\\/]+)\\}");

    public RequestMappingInformation(String path, String ... methods) {
        this(Collections.singleton(path), new HashSet<String>(Arrays.asList(methods)));
    }

    public RequestMappingInformation(Set<String> paths, Set<String> methods) {
        this.methods = methods;
        this.paths = new PathMatcher[paths.size()];
        this.rawPaths = paths;
        int i = 0;
        for (String path : paths) {
            this.paths[i] = this.convert(path);
            ++i;
        }
    }

    public Set<String> getRawPaths() {
        return this.rawPaths;
    }

    private PathMatcher convert(String path) {
        if (path.contains("{")) {
            return this.createPatternMatcher(path);
        }
        return new PlainPathMatcher(path);
    }

    private PathMatcher createPatternMatcher(String path) {
        LinkedList<String> names = new LinkedList<String>();
        Matcher m = pp.matcher(path);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String name = m.group(1);
            names.add(name);
            m.appendReplacement(sb, "([^\\/]+)");
        }
        m.appendTail(sb);
        Pattern pattern = Pattern.compile(sb.toString());
        return new PatternPathMatcher(pattern, names.toArray(new String[names.size()]));
    }

    public Match matches(HttpServletRequest request) {
        String rp = Requests.getRequestPath(request);
        String method = request.getMethod().toUpperCase();
        return this.matches(rp, method);
    }

    public Match matches(String path, String method) {
        if (!this.methods.isEmpty() && !this.methods.contains(method)) {
            return null;
        }
        PathMatcher[] pathMatcherArray = this.paths;
        int n = this.paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathMatcher pathMatcher = pathMatcherArray[n2];
            Map<String, String> result = pathMatcher.matches(path);
            if (result != null) {
                return new Match(result);
            }
            ++n2;
        }
        return null;
    }

    public class Match {
        private final Map<String, String> attributes;

        public Match(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }
    }
}

