/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.util;

import com.google.common.collect.Iterators;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameterOverridingRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameters;

    public ParameterOverridingRequestWrapper(HttpServletRequest request, Map<String, String[]> parameters) {
        super(request);
        this.parameters = parameters;
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Enumeration<String> getParameterNames() {
        return Iterators.asEnumeration(this.getParameterMap().keySet().iterator());
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length < 1) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }
}

