/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.ui;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.sec.service.AccessToken;
import org.eclipse.packagedrone.sec.service.AccessTokenService;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.sec.web.ui.AccessTokenBean;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.common.page.Pagination;
import org.eclipse.packagedrone.web.common.page.PaginationResult;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@ViewResolver(value="/WEB-INF/views/accessToken/%s.jsp")
@RequestMapping(value={"/accessToken"})
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class AccessTokenController
implements InterfaceExtender {
    private AccessTokenService accessTokenService;
    public static final Object TAG = new Object();

    public void setAccessTokenService(AccessTokenService accessTokenService) {
        this.accessTokenService = accessTokenService;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        if (request.isUserInRole("ADMIN")) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            result.add(new MenuEntry("Administration", 10000, "Access Tokens", 1200, LinkTarget.createFromController(AccessTokenController.class, (String)"list"), null, null));
            return result;
        }
        return null;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (request.isUserInRole("ADMIN")) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            if (object == TAG) {
                result.add(new MenuEntry("Create", 1000, LinkTarget.createFromController(AccessTokenController.class, (String)"create"), Modifier.PRIMARY, "plus"));
            }
            return result;
        }
        return null;
    }

    @RequestMapping
    public ModelAndView list(@RequestParameter(required=false, value="start") Integer position) {
        HashMap<String, PaginationResult> model = new HashMap<String, PaginationResult>();
        model.put("tokens", Pagination.paginate((Integer)position, (int)25, (arg_0, arg_1) -> ((AccessTokenService)this.accessTokenService).list(arg_0, arg_1)));
        return new ModelAndView("list", model);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public ModelAndView create() {
        HashMap<String, AccessTokenBean> model = new HashMap<String, AccessTokenBean>();
        model.put("command", new AccessTokenBean());
        return new ModelAndView("create", model);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public ModelAndView createPost(@FormData(value="command") AccessTokenBean command, BindingResult result) {
        HashMap model = new HashMap();
        if (result.hasErrors()) {
            return new ModelAndView("create", model);
        }
        this.accessTokenService.createAccessToken(command.getDescription());
        return ModelAndView.redirect((String)"/accessToken");
    }

    @RequestMapping(value={"/{id}/edit"}, method={RequestMethod.GET})
    public ModelAndView edit(@PathVariable(value="id") String id) {
        Optional token = this.accessTokenService.getToken(id);
        if (!token.isPresent()) {
            return CommonController.createNotFound((String)"access token", (String)id);
        }
        HashMap<String, AccessTokenBean> model = new HashMap<String, AccessTokenBean>();
        AccessTokenBean command = new AccessTokenBean();
        command.setDescription(((AccessToken)token.get()).getDescription());
        model.put("command", command);
        model.put("token", (AccessTokenBean)token.get());
        return new ModelAndView("edit", model);
    }

    @RequestMapping(value={"/{id}/edit"}, method={RequestMethod.POST})
    public ModelAndView editPost(@PathVariable(value="id") String id, @FormData(value="command") AccessTokenBean command, BindingResult result) {
        Optional token = this.accessTokenService.getToken(id);
        if (!token.isPresent()) {
            return CommonController.createNotFound((String)"access token", (String)id);
        }
        HashMap model = new HashMap();
        if (result.hasErrors()) {
            model.put("token", token.get());
            return new ModelAndView("edit", model);
        }
        this.accessTokenService.editAccessToken(id, command.getDescription());
        return ModelAndView.redirect((String)"/accessToken");
    }

    @RequestMapping(value={"/{id}/delete"}, method={RequestMethod.GET})
    public ModelAndView delete(@PathVariable(value="id") String id) {
        this.accessTokenService.deleteAccessToken(id);
        return ModelAndView.redirect((String)"/accessToken");
    }
}

