/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.ui;

import java.security.Principal;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.sec.DatabaseDetails;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.UserInformationPrincipal;
import org.eclipse.packagedrone.sec.service.LoginException;
import org.eclipse.packagedrone.sec.service.SecurityService;
import org.eclipse.packagedrone.sec.web.filter.SecurityFilter;
import org.eclipse.packagedrone.sec.web.ui.LoginData;
import org.eclipse.packagedrone.sec.web.ui.Sessions;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.scada.utils.ExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@RequestMapping(value={"/login"})
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    private SecurityService service;

    public void setService(SecurityService service) {
        this.service = service;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView login(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        LoginData data = new LoginData();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals("email")) {
                    data.setEmail(cookie.getValue());
                }
                ++n2;
            }
        }
        model.put("command", data);
        model.put("showAdminMode", this.needShowAdminMode());
        return new ModelAndView("login/form", model);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView loginPost(@FormData(value="command") LoginData data, HttpServletRequest request, HttpServletResponse response) {
        try {
            UserInformationPrincipal uip;
            UserInformation ui;
            Principal p;
            request.setAttribute(SecurityFilter.ATTR_REMEMBER_ME, (Object)data.isRememberMeSafe());
            request.login(data.getEmail(), data.getPassword());
            if (data.isRememberMeSafe() && (p = request.getUserPrincipal()) instanceof UserInformationPrincipal && (ui = (uip = (UserInformationPrincipal)p).getUserInformation()) != null) {
                DatabaseDetails dd = (DatabaseDetails)ui.getDetails(DatabaseDetails.class);
                String token = ui.getRememberMeToken();
                if (token != null) {
                    Cookie cookie = new Cookie("rememberMe", token);
                    cookie.setMaxAge((int)TimeUnit.DAYS.toSeconds(90L));
                    response.addCookie(cookie);
                    if (dd != null && dd.getEmail() != null) {
                        cookie = new Cookie("email", dd.getEmail());
                        cookie.setMaxAge((int)TimeUnit.DAYS.toSeconds(360L));
                        response.addCookie(cookie);
                    }
                }
            }
        }
        catch (ServletException e) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            Throwable root = ExceptionHelper.getRootCause((Throwable)e);
            if (root instanceof LoginException) {
                model.put("errorTitle", root.getMessage());
                model.put("details", ((LoginException)root).getDetails());
                long failures = Sessions.incrementLoginFailCounter(request.getSession());
                model.put("failureCount", failures);
            } else {
                logger.warn("Login error", (Throwable)e);
                model.put("errorTitle", "Internal error!");
                model.put("details", String.format("Failed to log in: %s", root.getClass().getSimpleName()));
            }
            model.put("showAdminMode", this.needShowAdminMode());
            return new ModelAndView("login/form", model);
        }
        Sessions.resetLoginFailCounter(request.getSession());
        return new ModelAndView("redirect:/");
    }

    private boolean needShowAdminMode() {
        return !this.service.hasUserBase();
    }
}

