/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.storage.apm.config;

import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.config.StorageManagerAdapter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;
    private ServiceRegistration<StorageManager> serviceHandle;
    private StorageManagerAdapter adapter;
    private ServiceRegistration<ManagedService> adapterHandle;
    private StorageManager service;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        String base = System.getProperty("drone.storage.base");
        if (base != null) {
            this.registerWithPath(base);
        } else {
            this.registerWithConfigAdmin();
        }
    }

    private void registerWithConfigAdmin() {
        logger.info("Register with config admin wrapper");
        this.adapter = new StorageManagerAdapter(this.context);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", "drone.storage.manager");
        this.adapterHandle = this.context.registerService(ManagedService.class, (Object)this.adapter, properties);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceHandle != null) {
            logger.info("Unregister storage service");
            this.serviceHandle.unregister();
            this.serviceHandle = null;
        }
        if (this.service != null) {
            logger.info("Stopping service");
            this.service.close();
            this.service = null;
        }
        if (this.adapterHandle != null) {
            logger.info("Unregister storage service adaptor");
            this.adapterHandle.unregister();
            this.adapterHandle = null;
        }
        if (this.adapter != null) {
            logger.info("Stopping storage service adaptor");
            this.adapter.dispose();
            this.adapter = null;
        }
    }

    private void registerWithPath(String base) {
        logger.info("Register with base path: {}", (Object)base);
        this.register(new StorageManager(Paths.get(base, new String[0])));
    }

    private void register(StorageManager storageManager) {
        Hashtable properties = new Hashtable();
        this.service = storageManager;
        this.serviceHandle = this.context.registerService(StorageManager.class, (Object)storageManager, properties);
    }
}

