/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.job.internal;

import org.eclipse.packagedrone.job.AbstractJsonJobFactory;
import org.eclipse.packagedrone.job.JobFactoryDescriptor;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.importer.Importer;
import org.eclipse.packagedrone.repo.importer.job.ImporterJobConfiguration;
import org.eclipse.packagedrone.repo.importer.job.ImporterResult;
import org.eclipse.packagedrone.repo.importer.job.internal.AbstractImportContext;
import org.eclipse.packagedrone.repo.importer.job.internal.ArtifactImportContext;
import org.eclipse.packagedrone.repo.importer.job.internal.ChannelImportContext;
import org.eclipse.packagedrone.web.LinkTarget;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class ImporterJob
extends AbstractJsonJobFactory<ImporterJobConfiguration, ImporterResult> {
    private static final LinkTarget TARGET = new LinkTarget("/import/job/{id}/result");
    private static final JobFactoryDescriptor DESCRIPTOR = new JobFactoryDescriptor(){

        public LinkTarget getResultTarget() {
            return TARGET;
        }
    };
    private ChannelService service;
    private final ServiceTracker<Importer, Importer> tracker = new ServiceTracker(FrameworkUtil.getBundle(Importer.class).getBundleContext(), Importer.class, null);

    public void setService(ChannelService service) {
        this.service = service;
    }

    public ImporterJob() {
        super(ImporterJobConfiguration.class);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    protected ImporterResult process(JobInstance.Context context, ImporterJobConfiguration cfg) throws Exception {
        AbstractImportContext ctx;
        Importer imp = this.getImporter(cfg.getImporterId());
        if (imp == null) {
            throw new IllegalArgumentException(String.format("Importer '%s' is unknown", cfg.getImporterId()));
        }
        switch (cfg.getDescriptor().getType()) {
            case "channel": {
                ctx = new ChannelImportContext(this.service, cfg.getDescriptor().getChannelId(), context);
                break;
            }
            case "artifact": {
                ctx = new ArtifactImportContext(this.service, cfg.getDescriptor().getChannelId(), cfg.getDescriptor().getArtifactParentId(), context);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown import type: %s", cfg.getDescriptor().getType()));
            }
        }
        try {
            imp.runImport(ctx, cfg.getConfiguration());
            ImporterResult importerResult = ctx.process();
            return importerResult;
        }
        finally {
            ctx.close();
        }
    }

    private Importer getImporter(String importerId) {
        for (Importer importer : this.tracker.getTracked().values()) {
            if (!importer.getDescription().getId().equals(importerId)) continue;
            return importer;
        }
        return null;
    }

    protected String makeLabelFromData(ImporterJobConfiguration data) {
        Importer importer = this.getImporter(data.getImporterId());
        if (importer != null) {
            return String.format("Import job - %s", importer.getDescription().getLabel());
        }
        return String.format("Import job: %s", data.getImporterId());
    }

    public JobFactoryDescriptor getDescriptor() {
        return DESCRIPTOR;
    }
}

