/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel;

import java.util.Collections;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelState;

public class ChannelInformation
extends ChannelId {
    private final ChannelState state;
    private final SortedMap<MetaKey, String> metaData;
    private final SortedMap<String, String> aspectStates;

    public ChannelInformation(ChannelId id, ChannelState state, SortedMap<MetaKey, String> metaData, SortedMap<String, String> aspectStates) {
        this(id.getId(), id.getNames(), id.getDescription(), state, metaData, aspectStates);
    }

    private ChannelInformation(String id, Set<String> names, String description, ChannelState state, SortedMap<MetaKey, String> metaData, SortedMap<String, String> aspectStates) {
        super(id, names, description);
        this.state = state;
        this.metaData = Collections.unmodifiableSortedMap(metaData);
        this.aspectStates = Collections.unmodifiableSortedMap(aspectStates);
    }

    public ChannelState getState() {
        return this.state;
    }

    public SortedMap<MetaKey, String> getMetaData() {
        return this.metaData;
    }

    public String getMetaData(MetaKey key) {
        return (String)this.metaData.get(key);
    }

    public String getMetaData(String namespace, String key) {
        return this.getMetaData(new MetaKey(namespace, key));
    }

    public SortedMap<String, String> getAspectStates() {
        return this.aspectStates;
    }

    public boolean hasAspect(String aspectId) {
        return this.aspectStates.containsKey(aspectId);
    }
}

