/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.AbstractWriter;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ArtifactRule;

public class ArtifactsWriter
extends AbstractWriter {
    private final List<String> fragments;
    private final long numberOfEntries;
    private final List<ArtifactRule> rules;

    public ArtifactsWriter(List<String> fragments, long numberOfEntries, String title, Instant now, Map<String, String> additionalProperties, boolean compressed, List<ArtifactRule> rules) {
        super("artifacts", title, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", now, compressed, additionalProperties);
        this.fragments = fragments;
        this.numberOfEntries = numberOfEntries;
        this.rules = rules;
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        this.writeMappings(out);
        this.writeArtifacts(out);
    }

    private void writeMappings(PrintWriter out) {
        out.append("  ").format("<mappings size='%d'>", this.rules.size()).append('\n');
        for (ArtifactRule rule : this.rules) {
            this.writeRule(out, rule.getFilter().toString(), rule.getPattern());
        }
        out.append("  ").append("</mappings>").append('\n');
    }

    private void writeRule(PrintWriter out, String filter, String output) {
        out.append("    ").format("<rule filter='%s' output='%s' />", XmlEscapers.xmlAttributeEscaper().escape(filter), XmlEscapers.xmlAttributeEscaper().escape(output)).append('\n');
    }

    private void writeArtifacts(PrintWriter out) {
        out.append("  ").format("<artifacts size='%s'>", this.numberOfEntries).append('\n');
        this.fragments.stream().forEach(out::append);
        out.append("  ").append("</artifacts>").append('\n');
    }
}

