/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.structure.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.papyrusrt.codegen.cpp.ConnectorReporter;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.Controller;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.ControllerAllocations;
import org.eclipse.papyrusrt.codegen.instance.model.CapsuleInstance;
import org.eclipse.papyrusrt.codegen.instance.model.ICapsuleInstance;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;

public class Deployment {
    private final ControllerAllocations controllerAllocations;
    private final Map<String, Controller> controllers = new TreeMap<String, Controller>();
    private final Map<ICapsuleInstance, Controller> capsules = new LinkedHashMap<ICapsuleInstance, Controller>();

    private Deployment(ControllerAllocations controllerAllocations) {
        this.controllerAllocations = controllerAllocations;
    }

    public static Deployment build(CppCodePattern cpp, Capsule topType, ControllerAllocations controllerAllocations) {
        Deployment deployment = new Deployment(controllerAllocations);
        CapsuleInstance topInstance = new CapsuleInstance(topType);
        ConnectorReporter connReporter = new ConnectorReporter((ICapsuleInstance)topInstance);
        topInstance.connect(connReporter, false);
        deployment.allocate((ICapsuleInstance)topInstance);
        connReporter.log(cpp.getOutputFolder());
        return deployment;
    }

    public Iterable<Controller> getControllers() {
        return this.controllers.values();
    }

    private void allocate(ICapsuleInstance capsule) {
        Controller controller = this.getController(capsule);
        controller.add(capsule);
        this.capsules.put(capsule, controller);
        for (ICapsuleInstance contained : capsule.getContained()) {
            this.allocate(contained);
        }
    }

    public Controller getController(ICapsuleInstance capsule) {
        if (capsule == null) {
            return new Controller("DefaultController");
        }
        Controller controller = this.capsules.get(capsule);
        if (controller != null) {
            return controller;
        }
        String controllerName = this.controllerAllocations.getController(capsule);
        if (controllerName == null) {
            controller = this.getController(capsule.getContainer());
            this.capsules.put(capsule, controller);
            return controller;
        }
        controller = this.controllers.get(controllerName);
        if (controller == null) {
            controller = new Controller(controllerName);
            this.controllers.put(controllerName, controller);
        }
        this.capsules.put(capsule, controller);
        return controller;
    }
}

