
#include "Ponger.hh"

#include "DataType1.hh"
#include "PingPongProtocol.hh"
#include "umlrtcapsuleclass.hh"
#include "umlrtcommsport.hh"
#include "umlrtcommsportfarend.hh"
#include "umlrtcommsportrole.hh"
#include "umlrtframeservice.hh"
#include "umlrtinmessage.hh"
#include "umlrtmain.hh"
#include "umlrtsignal.hh"
#include "umlrtslot.hh"
#include <cstddef>
class UMLRTRtsInterface;
struct UMLRTCommsPort;

#include <iostream>
#include <stdio.h>

Capsule_Ponger::Capsule_Ponger( const UMLRTCapsuleClass * cd, UMLRTSlot * st, const UMLRTCommsPort * * border, const UMLRTCommsPort * * internal, bool isStat )
: UMLRTCapsule( NULL, cd, st, border, internal, isStat )
, PongPort( borderPorts[borderport_PongPort] )
, currentState( SPECIAL_INTERNAL_STATE_UNVISITED )
{
    stateNames[top__Running] = "top__Running";
}





void Capsule_Ponger::bindPort( bool isBorder, int portId, int index )
{
    if( isBorder )
        switch( portId )
        {
        case borderport_PongPort:
            UMLRTFrameService::sendBoundUnbound( borderPorts, borderport_PongPort, index, true );
            break;
        }
}

void Capsule_Ponger::unbindPort( bool isBorder, int portId, int index )
{
    if( isBorder )
        switch( portId )
        {
        case borderport_PongPort:
            UMLRTFrameService::sendBoundUnbound( borderPorts, borderport_PongPort, index, false );
            UMLRTFrameService::disconnectPort( borderPorts[borderport_PongPort], index );
            break;
        }
}


void Capsule_Ponger::inject( const UMLRTInMessage & message )
{
    msg = &message;
    switch( currentState )
    {
    case top__Running:
        currentState = state_____top__Running( message );
        break;
    default:
        break;
    }
}

void Capsule_Ponger::initialize( const UMLRTInMessage & message )
{
    msg = &message;
    actionchain_____top__initial__ActionChain3( message );
    currentState = top__Running;
}

const char * Capsule_Ponger::getCurrentStateString() const
{
    return stateNames[currentState];
}




void Capsule_Ponger::transitionaction_____top__initial__ActionChain3__onInit( const UMLRTInMessage & msg )
{
    // UMLRT-CODEGEN:platform:/resource/PingPong/PingPong.uml#__Obm0FYKEeSmi4Fyw18d0w
    uint8_t buff0[msg.sizeDecoded()];
    void * const rtdata = buff0;
    msg.decode( rtdata );
    int limit = 0;
    if( UMLRTMain::getArgCount() > 0 )
    {
    	std::cout << "parsing arg '" << UMLRTMain::getArg( 0 ) << '\'' << std::endl;
    	limit = atoi( UMLRTMain::getArg( 0 ) );
    }

    if( limit <= 0 )
    	limit = 15;

    messageLimit = limit;

    std::cout << getName() << ": initialized with message limit " << messageLimit << std::endl;
    msg.destroy( (void *)buff0 );
}

void Capsule_Ponger::transitionaction_____top__onPing__ActionChain5__onPing( const UMLRTInMessage & msg )
{
    // UMLRT-CODEGEN:platform:/resource/PingPong/PingPong.uml#_szp-wCcREeSlGd4okkPIfw
    std::cout << getName() << ":received ping" << std::endl;
    UMLRTObject_fprintf(stdout, RTType_DataType1, msg.signal.getPayload(), 0/*nest*/, 2/*arraySize*/);

    uint8_t buff0[msg.sizeDecoded()*2];
    DataType1 * rtdata = (DataType1 *)buff0;
    msg.decode(rtdata, 2);
    std::cout << getName() <<
            " rtdata[0].field1_int[0] " << rtdata[0].field1_int[0] <<
            " rtdata[1].field1_int[1] " << rtdata[1].field1_int[1] <<
            " rtdata[0].field3_double " << rtdata[0].field3_double <<
            " rtdata[1].field3_double " << rtdata[1].field3_double <<
            " rtdata[1].sst1.[2].name " << rtdata[1].field4_sst1[2].name <<
            " rtdata[1].sst1.[2].integer " << rtdata[1].field4_sst1[2].integer <<
            std::endl;

    rtdata[0].field1_int[0]++;
    rtdata[0].field1_int[1]++;
    rtdata[1].field1_int[0]++;
    rtdata[2].field1_int[1]++;
    rtdata[0].field3_double += 1.;
    rtdata[1].field3_double += 1.;
    rtdata[0].field4_sst1[0].integer += 1;
    rtdata[0].field4_sst1[1].integer += 1;
    rtdata[0].field4_sst1[2].integer += 1;
    rtdata[1].field4_sst1[0].integer += 1;
    rtdata[1].field4_sst1[1].integer += 1;
    rtdata[1].field4_sst1[2].integer += 1;
    std::cout << "Sending pong" << std::endl;
    PongPort.pong((const DataType1 (&)[2])*rtdata).send();
    msg.destroy(rtdata, 2);

    if (rtdata[0].field1_int[0] >= messageLimit)
    {
        // Abort all controllers after we've exceeded the limit.
        context()->enqueueAbortAllControllers();
    }
}

void Capsule_Ponger::actionchain_____top__initial__ActionChain3( const UMLRTInMessage & msg )
{
    transitionaction_____top__initial__ActionChain3__onInit( msg );
}

void Capsule_Ponger::actionchain_____top__onPing__ActionChain5( const UMLRTInMessage & msg )
{
    transitionaction_____top__onPing__ActionChain5__onPing( msg );
}

Capsule_Ponger::State Capsule_Ponger::state_____top__Running( const UMLRTInMessage & msg )
{
    switch( msg.destPort->role()->id )
    {
    case port_PongPort:
        switch( msg.signal.getId() )
        {
        case PingPongProtocol::signal_ping:
            msg.decodeInit(RTType_DataType1); // Assume this is the place where parameter types are known.
            actionchain_____top__onPing__ActionChain5( msg );
            return top__Running;
        default:
            this->unexpectedMessage();
            break;
        }
        return currentState;
    default:
        this->unexpectedMessage();
        break;
    }
    return currentState;
}


static const UMLRTCommsPortRole portroles_border[] = 
{
    {
        Capsule_Ponger::port_PongPort,
        "PingPongProtocol",
        "PongPort",
        NULL,
        1,
        true,
        true,
        false,
        false,
        false,
        false,
        true
    }
};

static void instantiate_Ponger( const UMLRTRtsInterface * rts, UMLRTSlot * slot, const UMLRTCommsPort * * borderPorts )
{
    slot->capsule = new Capsule_Ponger( &Ponger, slot, borderPorts, NULL, false );
}

const UMLRTCapsuleClass Ponger = 
{
    "Ponger",
    NULL,
    instantiate_Ponger,
    0,
    NULL,
    1,
    portroles_border,
    0,
    NULL
};

