/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.instance.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrusrt.codegen.cpp.ConnectorReporter;
import org.eclipse.papyrusrt.codegen.instance.model.ICapsuleInstance;
import org.eclipse.papyrusrt.codegen.instance.model.IPortInstance;
import org.eclipse.papyrusrt.codegen.instance.model.PortInstance;
import org.eclipse.papyrusrt.codegen.utils.QualifiedNames;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.ConnectorEnd;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;

public class CapsuleInstance
implements ICapsuleInstance {
    private final Capsule type;
    private final CapsulePart part;
    private final ICapsuleInstance container;
    private final Integer index;
    private final boolean dynamic;
    private final Map<CapsulePart, List<CapsuleInstance>> contained = new HashMap<CapsulePart, List<CapsuleInstance>>();
    private final Map<Port, PortInstance> ports = new HashMap<Port, PortInstance>();

    public CapsuleInstance(Capsule top) {
        this.type = top;
        this.part = null;
        this.container = null;
        this.index = null;
        this.dynamic = false;
        this.constructPortInstances();
        this.constructCapsuleInstances();
    }

    @Override
    public Capsule getType() {
        return this.type;
    }

    @Override
    public CapsulePart getCapsulePart() {
        return this.part;
    }

    @Override
    public ICapsuleInstance getContainer() {
        return this.container;
    }

    @Override
    public int getIndex() {
        return this.index == null ? 0 : this.index;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public List<? extends ICapsuleInstance> getContained(CapsulePart part) {
        return this.contained.get(part);
    }

    @Override
    public List<IPortInstance> getPorts() {
        return new ArrayList<IPortInstance>(this.ports.values());
    }

    @Override
    public IPortInstance getPort(Port port) {
        return this.ports.get(port);
    }

    private CapsuleInstance(ICapsuleInstance container, Integer index, CapsulePart part, boolean dynamic) {
        this.type = part.getType();
        this.part = part;
        this.container = container;
        this.index = index;
        this.dynamic = dynamic;
        this.constructPortInstances();
        this.constructCapsuleInstances();
    }

    private void constructPortInstances() {
        for (Port port : XTUMLRTUtil.getAllRTPorts((Capsule)this.type)) {
            this.ports.put(port, new PortInstance(this, port));
        }
    }

    private void constructCapsuleInstances() {
        for (CapsulePart part : XTUMLRTUtil.getAllCapsuleParts((Capsule)this.type)) {
            boolean dynamic;
            ArrayList<CapsuleInstance> instances = new ArrayList<CapsuleInstance>();
            int lower = XTUMLRTUtil.getLowerBound((MultiplicityElement)part);
            int upper = XTUMLRTUtil.getUpperBound((MultiplicityElement)part);
            boolean bl = dynamic = lower <= 0;
            if (upper == 1) {
                instances.add(new CapsuleInstance(this, null, part, dynamic));
            } else {
                int i = 0;
                while (i < upper) {
                    if (i == lower) {
                        dynamic = true;
                    }
                    instances.add(new CapsuleInstance(this, i, part, dynamic));
                    ++i;
                }
            }
            this.contained.put(part, instances);
        }
    }

    public void connect(ConnectorReporter connReporter, boolean shallow) {
        for (Connector connector : XTUMLRTUtil.getAllConnectors((Capsule)this.type)) {
            this.connect(connReporter, connector);
        }
        if (!shallow) {
            for (List list : this.contained.values()) {
                for (CapsuleInstance capsuleInstance : list) {
                    capsuleInstance.connect(connReporter == null ? null : connReporter.createInner(capsuleInstance), false);
                }
            }
        }
    }

    private Iterable<CapsuleInstance> getInstancesFor(CapsulePart part) {
        List<CapsuleInstance> instances = this.contained.get(part);
        return instances == null ? Collections.singletonList(this) : instances;
    }

    private static boolean isSameConjugationCompatible(Port port0, Port port1) {
        Protocol t0 = port0.getType();
        if (t0 == null) {
            throw new RuntimeException("invalid attempt to generate ports " + QualifiedNames.fullName((NamedElement)port0) + " without Protocol");
        }
        Protocol t1 = port1.getType();
        if (t1 == null) {
            throw new RuntimeException("invalid attempt to generate ports " + QualifiedNames.fullName((NamedElement)port1) + " without Protocol");
        }
        Iterator outSignals0 = XTUMLRTUtil.getOutSignals((Protocol)t0).iterator();
        if (outSignals0.hasNext()) {
            return false;
        }
        Iterator outSignals1 = XTUMLRTUtil.getOutSignals((Protocol)t1).iterator();
        return !outSignals1.hasNext();
    }

    private void connect(ConnectorReporter connReporter, Connector connector) {
        ConnectorEnd[] ends = (ConnectorEnd[])connector.getEnds().toArray((Object[])new ConnectorEnd[2]);
        if (ends.length != 2) {
            return;
        }
        ConnectorBuilder cb = new ConnectorBuilder(new End(this.part, ends[0]), new End(this.part, ends[1]));
        boolean isRelay0 = false;
        boolean isRelay1 = false;
        if (cb.primary.port.isConjugate() == cb.secondary.port.isConjugate()) {
            if (cb.primary.part == this.part) {
                isRelay0 = this.ports.containsKey(cb.primary.port);
            }
            if (cb.secondary.part == this.part) {
                isRelay1 = this.ports.containsKey(cb.secondary.port);
            }
            if (!(isRelay0 || isRelay1 || CapsuleInstance.isSameConjugationCompatible(cb.primary.port, cb.secondary.port))) {
                throw new RuntimeException("invalid attempt to connect ports with incompatible conjugation");
            }
        }
        int perPrimaryRole = cb.secondary.numPortInstances / cb.primary.numParts;
        Iterator<CapsuleInstance> secondaryCapsuleIterator = this.getInstancesFor(cb.secondary.part).iterator();
        CapsuleInstance secondaryCapsule = secondaryCapsuleIterator.hasNext() ? secondaryCapsuleIterator.next() : null;
        for (CapsuleInstance cap0 : this.getInstancesFor(cb.primary.part)) {
            int i = 0;
            while (secondaryCapsule != null && i < perPrimaryRole) {
                PortInstance.FarEnd farEnd0 = cap0.createFarEnd(cb.primary.port, isRelay0);
                PortInstance.FarEnd farEnd1 = secondaryCapsule.createFarEnd(cb.secondary.port, isRelay1);
                if (farEnd1 == null) {
                    if (!secondaryCapsuleIterator.hasNext()) {
                        throw new RuntimeException("not enough secondary capsule instances to connect " + cb.primary.toString() + " and " + cb.secondary.toString() + " with " + connector.getName());
                    }
                    secondaryCapsule = secondaryCapsuleIterator.next();
                    farEnd1 = secondaryCapsule.createFarEnd(cb.secondary.port, isRelay1);
                }
                farEnd0.connectWith(farEnd1);
                farEnd1.connectWith(farEnd0);
                if (connReporter != null) {
                    connReporter.record(connector, farEnd0, farEnd1);
                }
                ++i;
            }
        }
    }

    private PortInstance.FarEnd createFarEnd(Port umlPort, boolean isRelay) {
        PortInstance portInstance = this.ports.get(umlPort);
        if (portInstance == null) {
            return null;
        }
        PortInstance.FarEnd far = null;
        if (isRelay) {
            far = portInstance.convertToRelay();
        }
        return far == null ? portInstance.createFarEnd() : far;
    }

    @Override
    public String getQualifiedName(char sep) {
        String base = null;
        if (this.part != null) {
            base = this.part.getName();
        } else {
            String name = this.type.getName();
            if (name == null || name.isEmpty()) {
                base = "Top";
            }
            base = name;
        }
        if (this.container != null) {
            base = String.valueOf(this.container.getQualifiedName(sep)) + sep + base;
        }
        if (this.index == null) {
            return base;
        }
        switch (sep) {
            case '.': {
                return String.valueOf(base) + '[' + this.index + ']';
            }
        }
        return String.valueOf(base) + sep + this.index;
    }

    @Override
    public List<ICapsuleInstance> getContained() {
        ArrayList<ICapsuleInstance> list = new ArrayList<ICapsuleInstance>();
        for (List<CapsuleInstance> capsules : this.contained.values()) {
            list.addAll(capsules);
        }
        return list;
    }

    public String toString() {
        return this.getQualifiedName('.');
    }

    private static class ConnectorBuilder {
        public final End primary;
        public final End secondary;

        public ConnectorBuilder(End end0, End end1) {
            if (end0.numPortInstances >= end1.numPortInstances) {
                this.primary = end0;
                this.secondary = end1;
            } else {
                this.primary = end1;
                this.secondary = end0;
            }
        }
    }

    public static class End {
        public final CapsulePart part;
        public final Port port;
        public final int numParts;
        public final int numPortInstances;

        public End(CapsulePart containingPart, ConnectorEnd connectorEnd) {
            CapsulePart p = connectorEnd.getPartWithPort();
            this.part = p == null ? containingPart : p;
            this.port = connectorEnd.getRole();
            this.numParts = this.part == null ? 1 : XTUMLRTUtil.getUpperBound((MultiplicityElement)this.part);
            this.numPortInstances = this.numParts * XTUMLRTUtil.getUpperBound((MultiplicityElement)this.port);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(this.part.getName());
            str.append('.');
            str.append(this.port.getName());
            str.append("{numPortInstances:");
            str.append(this.numPortInstances);
            str.append(", numParts:");
            str.append(this.numParts);
            str.append('}');
            return str.toString();
        }
    }
}

