/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp;

import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class Name
implements Comparable<Name> {
    private NamedElement parent;
    private final String identifier;

    public Name(String ident) {
        this.identifier = Name.asValidCIdentifier(ident);
    }

    private static String asValidCIdentifier(String ident) {
        return ident.replaceAll("[\\s\\-]+", "_");
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Name getParent() {
        return this.parent == null ? null : this.parent.getName();
    }

    public void setParent(NamedElement parent) {
        this.parent = parent;
    }

    @Override
    public int compareTo(Name o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public boolean writeQualified(CppFormatter fmt, Name context) {
        StringBuilder nameStr = new StringBuilder();
        this.appendFullyQualified(nameStr);
        String nameQN = nameStr.toString();
        if (context == null) {
            return fmt.write(nameQN);
        }
        StringBuilder contextStr = new StringBuilder();
        context.appendFullyQualified(contextStr);
        String contextQN = contextStr.toString();
        String[] ctx = contextQN.split("::");
        String[] name = nameQN.split("::");
        int i = 0;
        int limit = Math.min(ctx.length, name.length - 1);
        while (i < limit && ctx[i].equals(name[i])) {
            ++i;
        }
        if (i > 0) {
            StringBuilder str = new StringBuilder();
            while (i < name.length) {
                str.append(name[i]);
                if (++i == name.length) break;
                str.append("::");
            }
            nameQN = str.toString();
        }
        return fmt.write(nameQN);
    }

    private void appendFullyQualified(StringBuilder str) {
        if (this.parent != null) {
            this.parent.getName().appendFullyQualified(str);
            str.append("::");
        }
        str.append(this.getIdentifier());
    }

    public String toString() {
        return this.getIdentifier();
    }
}

