/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.dep;

import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public abstract class Dependency
implements Comparable<Dependency> {
    private final Kind kind;

    protected Dependency(Kind kind) {
        this.kind = kind;
    }

    protected boolean writeReference(CppFormatter fmt) {
        return this.writeUse(fmt);
    }

    protected abstract boolean writeUse(CppFormatter var1);

    protected int compareReference(Dependency dep) {
        return this.compareUse(dep);
    }

    protected abstract int compareUse(Dependency var1);

    protected abstract boolean isReferenceProvidedInUse(Dependency var1);

    protected abstract Element getComparisonElement();

    protected abstract HeaderFile getHeader();

    @Override
    public int compareTo(Dependency o) {
        int cmp = this.kind.compareTo(o.kind);
        if (cmp != 0) {
            return cmp;
        }
        switch (this.kind) {
            case Use: {
                return this.compareUse(o);
            }
            case Reference: {
                return this.compareReference(o);
            }
        }
        throw new RuntimeException("cannot compare " + this.toString() + " with " + o.toString());
    }

    public boolean isProvidedBy(Dependency other) {
        if (this.kind == Kind.Reference && other.kind == Kind.Use) {
            return this.isReferenceProvidedInUse(other);
        }
        return false;
    }

    public boolean write(CppFormatter fmt) {
        switch (this.kind) {
            case Use: {
                return this.writeUse(fmt);
            }
            case Reference: {
                return this.writeReference(fmt);
            }
        }
        return false;
    }

    protected static enum Kind {
        Use,
        Reference;

    }
}

