/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.codegen.base.codesync.ChangeObject;
import org.eclipse.papyrus.codegen.base.codesync.ManageChangeEvents;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.CppProjectGenerator;
import org.eclipse.papyrusrt.codegen.utils.ProjectUtils;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.UML2xtumlrtModelTranslator;

public class UMLRTGenerator {
    private static boolean regenerate = false;

    public static void setRegenerate(boolean flag) {
        regenerate = flag;
    }

    public static IStatus generate(List<EObject> elements, String top) {
        UML2xtumlrtModelTranslator translator = new UML2xtumlrtModelTranslator();
        CppCodePattern cpp = new CppCodePattern();
        CppCodeGenerator codegen = new CppCodeGenerator(cpp, translator);
        codegen.setTop(top);
        if (regenerate) {
            codegen.getChangeTracker().resetAll();
        }
        ArrayList<ChangeObject> changes = new ArrayList<ChangeObject>();
        HashMap<File, ArrayList<EObject>> targets = new HashMap<File, ArrayList<EObject>>();
        HashMap<File, IFolder> outputFolders = new HashMap<File, IFolder>();
        for (EObject eobj : elements) {
            UMLRTGenerator.getChanges(changes, eobj);
            File modelFolder = UMLRTGenerator.getModelFolder(eobj);
            ArrayList<EObject> list = (ArrayList<EObject>)targets.get(modelFolder);
            if (list == null) {
                list = new ArrayList<EObject>();
                targets.put(modelFolder, list);
            }
            list.add(eobj);
            IFolder outputFolder = (IFolder)outputFolders.get(modelFolder);
            if (outputFolder != null) continue;
            outputFolder = UMLRTGenerator.getOutputFolder(eobj);
            outputFolders.put(modelFolder, outputFolder);
        }
        codegen.getChangeTracker().addChanges(changes);
        Collection changedElements = codegen.getChangeTracker().getAllChanged();
        MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator Invoked", null);
        long start = System.currentTimeMillis();
        if (targets.isEmpty()) {
            status.add(CodeGenPlugin.error((String)"Selection must contain at least one model element"));
        } else {
            try {
                for (Map.Entry entry : targets.entrySet()) {
                    File modelFolder = (File)entry.getKey();
                    java.nio.file.Path path = modelFolder.toPath();
                    IFolder outputFolder = (IFolder)outputFolders.get(modelFolder);
                    translator.setTargets((List)entry.getValue());
                    translator.setOutputPath(path);
                    translator.setChangeSet(changedElements);
                    try {
                        status.addAll(translator.generate());
                    }
                    catch (Throwable t) {
                        status.add(CodeGenPlugin.error((String)"Error during translation", (Throwable)t));
                        t.printStackTrace(System.err);
                        continue;
                    }
                    List translated = translator.getAllGenerated();
                    if (translated == null || translated.isEmpty()) continue;
                    cpp.setOutputFolder(outputFolder.getLocation().toFile());
                    cpp.setModelFolder(modelFolder);
                    codegen.setTargets(translated);
                    try {
                        status.addAll(codegen.generate());
                    }
                    catch (Throwable t) {
                        status.add(CodeGenPlugin.error((String)"Error during generation", (Throwable)t));
                        t.printStackTrace(System.err);
                        continue;
                    }
                    long writeStart = System.currentTimeMillis();
                    if (cpp.write()) {
                        status.add(CodeGenPlugin.info((String)("Updated generated files " + (System.currentTimeMillis() - writeStart) + "ms")));
                    } else {
                        status.add(CodeGenPlugin.error((String)"Failed to write generated model to disk"));
                    }
                    outputFolder.refreshLocal(2, null);
                }
            }
            catch (Throwable t) {
                CodeGenPlugin.error((String)"error during codegen action", (Throwable)t);
                status.add(CodeGenPlugin.error((Throwable)t));
            }
        }
        String message = "Generation " + (status.getSeverity() <= 1 ? "complete" : "error") + ", elapsed time " + (System.currentTimeMillis() - start) + " ms";
        MultiStatus result = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, message, null);
        result.addAll((IStatus)status);
        return result;
    }

    private static void getChanges(List<ChangeObject> changes, EObject object) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)object);
        if (domain != null) {
            EList changeList = ManageChangeEvents.getChangeList((TransactionalEditingDomain)domain);
            ManageChangeEvents.stopRecording((TransactionalEditingDomain)domain);
            ManageChangeEvents.initChangeList((TransactionalEditingDomain)domain, (boolean)true);
            if (changeList != null) {
                changes.addAll((Collection<ChangeObject>)changeList);
            }
        }
    }

    private static File getModelFolder(EObject eobj) {
        if (eobj == null) {
            return null;
        }
        URI eobjUri = EcoreUtil.getURI((EObject)eobj);
        if (eobjUri == null) {
            return null;
        }
        Path path = new Path(eobjUri.toPlatformString(true));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (file == null || !file.exists()) {
            return null;
        }
        IContainer modelContainer = file.getParent();
        if (modelContainer == null || !modelContainer.exists()) {
            return null;
        }
        return modelContainer.getLocation().makeAbsolute().toFile();
    }

    private static IFolder getOutputFolder(EObject eobj) {
        String projectName = ProjectUtils.getProjectName((EObject)eobj);
        projectName = String.valueOf(projectName) + "_CDTProject";
        String rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            boolean result = new CppProjectGenerator().generate(rootPath, projectName);
            if (!result) {
                CodeGenPlugin.error((String)"Failed to create output project");
                return null;
            }
            try {
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(rootPath) + "/" + projectName + "/.project"));
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
                project.create(description, null);
            }
            catch (CoreException coreException) {
                CodeGenPlugin.error((String)"Failed to create output project");
            }
        }
        if (!project.isOpen()) {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                CodeGenPlugin.error((String)"Failed to open project");
            }
        }
        IFolder folder = project.getFolder("src");
        try {
            folder.refreshLocal(0, null);
        }
        catch (CoreException e) {
            CodeGenPlugin.error((String)"could not refresh output folder", (Throwable)e);
        }
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                CodeGenPlugin.error((String)"could not create output folder", (Throwable)e);
            }
        }
        return folder;
    }
}

