/*******************************************************************************
* Copyright (c) 2015 Zeligsoft (2009) Limited  and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.papyrusrt.codegen.xtumlrt.trans

import org.eclipse.emf.ecore.EObject
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.GenerationProperties
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement
import org.eclipse.emf.ecore.EEnumLiteral

class RTCppGenerationProperties extends GenerationProperties
{

    static val ALL_CPP_FILE_STEREOTYPES =
    #[
        "CppFileProperties",
        "ClassProperties",
        "CapsuleProperties"
    ]

    static enum AttributeKind
    {
        MEMBER,
        GLOBAL,
        MUTABLE_MEMBER,
        DEFINE
    }

    static val ATTR_KIND_EENUMS =
    #[
        AttributeKind.MEMBER,
        AttributeKind.GLOBAL,
        AttributeKind.MUTABLE_MEMBER,
        AttributeKind.DEFINE
    ]

    static def getAttributeProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isAttributeProperties ]
    }

    static def getAttributePropKind( CommonElement element )
    {
        val eEnumLiteral = getProperty( element, "AttributeProperties", "kind" ) as EEnumLiteral
        if (eEnumLiteral === null) null else ATTR_KIND_EENUMS.get( eEnumLiteral.value )
    }

    static def getAttributePropInitialization( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "initialization" ) as EEnumLiteral
    }

    static def getAttributePropVolatile( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "volatile" ) as Boolean
    }

    static def getAttributePropType( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "type" ) as String
    }

    static def getAttributePropSize( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "size" ) as String
    }

    static def getAttributePropPointsTo( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "pointsToType" ) as Boolean
    }

    static def getAttributePropPointsToConst( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "pointsToConstType" ) as Boolean
    }

    static def getAttributePropPointsToVolatile( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "pointsToVolatileType" ) as Boolean
    }

    static def getCppFileProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isCppFileProperties ]
    }

    static def getCppFileHeaderPreface( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "headerPreface" ) as String
    }

    static def getCppFileHeaderEnding( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "headerEnding" ) as String
    }

    static def getCppFileImplementationPreface( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "implementationPreface" ) as String
    }

    static def getCppFileImplementationEnding( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "implementationEnding" ) as String
    }

    static def getParameterProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isParameterProperties ]
    }

    static def getParameterPropType( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "type" ) as String
    }

    static def getParameterPropPointsTo( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "pointsToType" ) as Boolean
    }

    static def getParameterPropPointsToConst( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "pointsToConst" ) as Boolean
    }

    static def getParameterPropPointsToVolatile( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "pointsToVolatile" ) as Boolean
    }

    static def hasAttributeKind( CommonElement element, AttributeKind expectedKind )
    {
        val kind = element?.getAttributePropKind
        kind !== null && kind == expectedKind
    }

    static def hasAttributeKindMember( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.MEMBER )
    }

    static def hasAttributeKindGlobal( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.GLOBAL )
    }

    static def hasAttributeKindMutableMember( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.MUTABLE_MEMBER )
    }

    static def hasAttributeKindDefine( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.DEFINE )
    }

    static def isAttributeProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "AttributeProperties"
    }

    static def isCppFileProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "CppFileProperties"
    }

    static def isParameterProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "ParameterProperties"
    }

}