/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.protocoleditor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UMLRTModelElementSelectionService
implements IStartup,
ISelectionListener {
    private static ISelection selection;
    private static Set<IModelExplorerSelectionChangeListener> listeners;

    static {
        listeners = new HashSet<IModelExplorerSelectionChangeListener>();
    }

    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                UMLRTModelElementSelectionService.this.addSelectionListener(window);
            }

            public void windowClosed(IWorkbenchWindow window) {
                UMLRTModelElementSelectionService.this.removeSelectionListener(window);
            }

            public void windowActivated(IWorkbenchWindow arg0) {
            }

            public void windowDeactivated(IWorkbenchWindow arg0) {
            }
        });
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    UMLRTModelElementSelectionService.this.addSelectionListener(window);
                    ++n2;
                }
            }
        });
    }

    private void addSelectionListener(IWorkbenchWindow window) {
        if (window != null) {
            window.getSelectionService().addSelectionListener("org.eclipse.papyrus.views.modelexplorer.modelexplorer", (ISelectionListener)this);
        }
    }

    private void removeSelectionListener(IWorkbenchWindow window) {
        if (window != null) {
            window.getSelectionService().removeSelectionListener("org.eclipse.papyrus.views.modelexplorer.modelexplorer", (ISelectionListener)this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        UMLRTModelElementSelectionService.selection = selection;
        this.fireSelectionChangedEvent(selection);
    }

    private synchronized void fireSelectionChangedEvent(ISelection selection) {
        for (IModelExplorerSelectionChangeListener l : listeners) {
            l.selectionChanged(selection);
        }
    }

    public static void addListener(IModelExplorerSelectionChangeListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(IModelExplorerSelectionChangeListener listener) {
        listeners.remove(listener);
    }

    public static EObject getSelectedEObject() {
        if (!selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof IAdaptable) {
            return (EObject)((IAdaptable)((IStructuredSelection)selection).getFirstElement()).getAdapter(EObject.class);
        }
        return null;
    }

    public static interface IModelExplorerSelectionChangeListener {
        public void selectionChanged(ISelection var1);
    }
}

