/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.protocoleditor.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrusrt.protocoleditor.internal.UMLRTProtocolUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class UMLRTProtocolMenuHandler
extends AbstractHandler {
    private TransactionalEditingDomain editingDomain;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject eObject;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        Package selectedPackage = null;
        if (((IStructuredSelection)sel).getFirstElement() instanceof IAdaptable && (eObject = (EObject)((IAdaptable)((IStructuredSelection)sel).getFirstElement()).getAdapter(EObject.class)) instanceof Package) {
            selectedPackage = (Package)eObject;
        }
        if (selectedPackage == null) {
            return null;
        }
        this.editingDomain = TransactionUtil.getEditingDomain(selectedPackage);
        if (this.editingDomain == null) {
            throw new IllegalStateException("Editing domain not found.");
        }
        final Package container = selectedPackage;
        IInputValidator validator = new IInputValidator(){

            public String isValid(String name) {
                Package pkg = container.getNestedPackage(name);
                if (pkg != null) {
                    return "Invalid name. Name already exist.";
                }
                return null;
            }
        };
        InputDialog nameDialog = new InputDialog(Display.getCurrent().getActiveShell(), "Create Protocol", "Enter protocol name", "protocol", validator);
        int result = nameDialog.open();
        if (result == 0) {
            final String name = nameDialog.getValue();
            RecordingCommand command = new RecordingCommand(this.editingDomain){

                protected void doExecute() {
                    UMLRTProtocolMenuHandler.this.createProtocolContainer(container, name);
                }
            };
            this.editingDomain.getCommandStack().execute((Command)command);
        }
        return null;
    }

    private Package createProtocolContainer(Package container, String name) {
        Package pContainer = container.createNestedPackage(name);
        UMLRTProtocolUtil.applyStereoType((Element)pContainer, "UMLRealTime::ProtocolContainer");
        return pContainer;
    }
}

