/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.protocoleditor.listeners;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.tools.listeners.PapyrusStereotypeListener;
import org.eclipse.papyrus.umlrt.UMLRealTime.ProtocolContainer;
import org.eclipse.papyrusrt.codegen.utils.UMLRealTimeProfileUtil;
import org.eclipse.papyrusrt.protocoleditor.internal.UMLRTProtocolUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTProtocolListener
extends ResourceSetListenerImpl {
    public void resourceSetChanged(ResourceSetChangeEvent event) {
        for (Notification n : event.getNotifications()) {
            n.getNotifier();
        }
        super.resourceSetChanged(event);
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        for (Notification notification : event.getNotifications()) {
            Operation op;
            Interface intf;
            Package protocolContainer;
            Object newValue;
            if (!(notification.getNotifier() instanceof Element)) continue;
            Element notifier = (Element)notification.getNotifier();
            if (notification instanceof PapyrusStereotypeListener.StereotypeCustomNotification && 20 == notification.getEventType() && (newValue = notification.getNewValue()) instanceof ProtocolContainer) {
                Package protocolContainer2 = (Package)notifier;
                return this.getCommandForNameChange(event.getEditingDomain(), protocolContainer2, protocolContainer2.getName(), protocolContainer2.getName());
            }
            if (notification.getEventType() == 1 && (UMLRealTimeProfileUtil.isProtocol((Element)notifier) || UMLRealTimeProfileUtil.isProtocolContainer((Element)notifier)) && notification.getFeature().equals(UMLPackage.Literals.NAMED_ELEMENT__NAME) && (protocolContainer = UMLRTProtocolUtil.getProtocolContainer((EObject)notifier)) != null && !UML2Util.isEmpty((String)notification.getOldStringValue())) {
                return this.getCommandForNameChange(event.getEditingDomain(), protocolContainer, notification.getOldStringValue(), notification.getNewStringValue());
            }
            if (notification.getEventType() == 1 && notification.getFeature().equals(UMLPackage.Literals.NAMED_ELEMENT__NAME) && notifier instanceof Operation && notifier.eContainer() instanceof Element && UMLRealTimeProfileUtil.isRTMessageSet((Element)((Element)notifier.eContainer()))) {
                return this.getCommandForOperationNameChange(event.getEditingDomain(), (Operation)notifier, notification.getOldStringValue(), notification.getNewStringValue());
            }
            if (notification.getEventType() == 1 && notification.getFeature().equals(UMLPackage.Literals.OPERATION__INTERFACE) && notification.getOldValue() instanceof Element && notification.getNewValue() == null && UMLRealTimeProfileUtil.isRTMessageSet((Element)((Element)notification.getOldValue()))) {
                boolean isMove = false;
                for (Notification notification2 : event.getNotifications()) {
                    Element notifier2;
                    if (!(notification2.getNotifier() instanceof Element) || !notifier.equals(notifier2 = (Element)notification2.getNotifier()) || notification2.getEventType() != 1 || !notification2.getFeature().equals(UMLPackage.Literals.OPERATION__INTERFACE) || !(notification2.getNewValue() instanceof Element) || notification2.getOldValue() != null || !UMLRealTimeProfileUtil.isRTMessageSet((Element)((Element)notification2.getNewValue()))) continue;
                    isMove = true;
                    break;
                }
                if (!isMove) {
                    return this.getCommandForRemoveOperation(event.getEditingDomain(), (Element)notification.getOldValue(), (Operation)notifier);
                }
                return null;
            }
            if (notification.getEventType() == 3 && notification.getFeature().equals(UMLPackage.Literals.INTERFACE__OWNED_OPERATION) && !UML2Util.isEmpty((String)((Operation)notification.getNewValue()).getName()) && UMLRealTimeProfileUtil.isRTMessageSet((Element)notifier)) {
                return this.getCommandForOperationNameChange(event.getEditingDomain(), (Operation)notification.getNewValue(), "", ((Operation)notification.getNewValue()).getName());
            }
            if (notification.getFeature().equals(UMLPackage.Literals.BEHAVIORAL_FEATURE__OWNED_PARAMETER) && notifier instanceof Operation && (intf = (op = (Operation)notifier).getInterface()) != null && UMLRealTimeProfileUtil.isRTMessageSet((Element)intf)) {
                return this.getCommandForOperationNameChange(event.getEditingDomain(), op, op.getName(), op.getName());
            }
            if (notification.getEventType() != 1 || !notification.getFeature().equals(UMLPackage.Literals.TYPED_ELEMENT__TYPE) || !(notifier instanceof Parameter) || (op = ((Parameter)notifier).getOperation()) == null || (intf = op.getInterface()) == null || !UMLRealTimeProfileUtil.isRTMessageSet((Element)intf)) continue;
            return this.getCommandForOperationNameChange(event.getEditingDomain(), op, op.getName(), op.getName());
        }
        return null;
    }

    private Command getCommandForRemoveOperation(TransactionalEditingDomain editingDomain, final Element messageSet, final Operation operation) {
        return new RecordingCommand(editingDomain){

            protected void doExecute() {
                Package protocolContainer = UMLRTProtocolUtil.getProtocolContainer((EObject)messageSet);
                if (protocolContainer == null) {
                    return;
                }
                CallEvent callEvent = (CallEvent)protocolContainer.getPackagedElement(operation.getName(), false, UMLPackage.Literals.CALL_EVENT, false);
                if (callEvent != null) {
                    EcoreUtil.delete((EObject)callEvent);
                }
            }
        };
    }

    private Command getCommandForOperationNameChange(TransactionalEditingDomain editingDomain, final Operation operation, final String oldName, final String newName) {
        return new RecordingCommand(editingDomain){

            protected void doExecute() {
                Package protocolContainer = UMLRTProtocolUtil.getProtocolContainer((EObject)operation);
                if (protocolContainer == null) {
                    return;
                }
                StringBuilder postfix = new StringBuilder();
                for (Parameter p : operation.getOwnedParameters()) {
                    if (!ParameterDirectionKind.IN_LITERAL.equals((Object)p.getDirection()) || p.getType() == null) continue;
                    postfix.append("_");
                    postfix.append(p.getType().getName());
                }
                String postfixString = postfix.toString();
                CallEvent callEvent = null;
                for (PackageableElement e : protocolContainer.getPackagedElements()) {
                    if (!(e instanceof CallEvent) || !operation.equals(((CallEvent)e).getOperation())) continue;
                    e.setName(String.valueOf(newName) + postfixString);
                    return;
                }
                String oldEventName = String.valueOf(oldName) + postfixString;
                String newEventName = String.valueOf(newName) + postfixString;
                if (!UML2Util.isEmpty((String)oldEventName)) {
                    callEvent = (CallEvent)protocolContainer.getPackagedElement(oldEventName, false, UMLPackage.Literals.CALL_EVENT, false);
                }
                if (callEvent == null) {
                    callEvent = (CallEvent)protocolContainer.getPackagedElement(newEventName, false, UMLPackage.Literals.CALL_EVENT, true);
                }
                if (callEvent != null) {
                    callEvent.setOperation(operation);
                    callEvent.setName(newEventName);
                }
            }
        };
    }

    private Command getCommandForNameChange(TransactionalEditingDomain editingDomain, final Package protocolContainer, final String oldStringValue, final String newStringValue) {
        return new RecordingCommand(editingDomain){

            protected void doExecute() {
                UMLRTProtocolUtil.createProtocolContainerContent(protocolContainer, oldStringValue, newStringValue);
            }
        };
    }
}

