// umlrtrtsinterface.hh

/*******************************************************************************
* Copyright (c) 2015 Zeligsoft (2009) Limited  and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/

#ifndef UMLRTRTSINTERFACE_HH
#define UMLRTRTSINTERFACE_HH

#include <stdlib.h>

class UMLRTCapsule;
struct UMLRTCapsuleClass;
struct UMLRTCommsPort;
struct UMLRTCommsPortRole;
struct UMLRTSlot;

// An instance of an object of this type is used to access the RTS from capsule-instance code.

class UMLRTRtsInterface
{
public:
    // Used to connect two ports. If the far-end of 'p1' already exists, it is the far-end of 'p1' that gets connected to 'p2'.
    virtual void connectPorts ( const UMLRTCommsPort * p1, size_t p1Index, const UMLRTCommsPort * p2, size_t p2Index ) const = 0;

    // Create a connection between the far end of the 'relay' port to the 'dest' port. The relay port itself is not modified.
    virtual void connectRelayPort ( const UMLRTCommsPort * relayPort, size_t relayIndex, const UMLRTCommsPort * destPort, size_t destIndex ) const = 0;

    // Used for creating a border-port-list from a slot, passed to a capsule instantiate function.
    virtual const UMLRTCommsPort * * createBorderPorts ( UMLRTSlot * slot, size_t numPorts ) const = 0;

    // Create a internal port list. No ports are connected yet.
    virtual const UMLRTCommsPort * createInternalPorts ( UMLRTSlot * slot, const UMLRTCapsuleClass * capsuleClass, size_t numPortRoles, const UMLRTCommsPortRole portRoles[] ) const = 0;

    // The capsule is declaring the port as 'bound'. The port is not a relay port.
    virtual void bindPort ( const UMLRTCommsPort * * borderPorts, int portId, int index ) const = 0;
    virtual void bindPort ( const UMLRTCommsPort * internalPorts, int portId, int index ) const = 0;

    // The capsule is binding the port to a sub-capsule port. The port a relay port.
    virtual void bindSubcapsulePort ( bool isBorder, UMLRTCapsule * subcapsule, int portIndex, int farEndIndex ) const = 0;

    // The capsule is unbinding its port. The port is not a relay port.
    virtual void unbindPort ( const UMLRTCommsPort * * borderPorts, int portId, int index ) const = 0;
    virtual void unbindPort ( const UMLRTCommsPort * internalPorts, int portId, int index ) const = 0;

    // The capsule is unbinding the port from a sub-capsule port. The port a relay port.
    virtual void unbindSubcapsulePort ( bool isBorder, UMLRTCapsule * subcapsule, int portIndex, int farEndIndex ) const = 0;

};

#endif // UMLRTRTSINTERFACE_HH
