package org.eclipse.papyrusrt.umlrt.core.utils;

public enum CapsulePartKindEnum {

	/**
	 * Fixed kind of capsule Part
	 */
	FIXED(0, "Fixed"),

	/**
	 * Optional kind of capsule Part
	 */
	OPTIONAL(1, "Optional"),

	/**
	 * Plugin kind of capsule Part
	 */
	PLUGIN(2, "Plugin");



	private final String label;

	private final int index;

	public String getLabel() {

		return label;
	}

	public int getIndex() {

		return index;
	}

	private CapsulePartKindEnum(int index, String label) {
		this.label = label;
		this.index = index;

	}

	@Override
	public String toString() {
		return label;
	}

}
