/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrusrt.umlrt.core.Activator;

public class ElementTypeUtils {
    public static Boolean matches(EObject element, String elementTypeId) {
        IElementType type = ElementTypeRegistry.getInstance().getType(elementTypeId);
        if (!(type instanceof ISpecializationType)) {
            return false;
        }
        IElementMatcher matcher = ((ISpecializationType)type).getMatcher();
        if (matcher == null) {
            Activator.log.error("no matcher provided for type: " + type, null);
            return false;
        }
        if (matcher.matches(element)) {
            return true;
        }
        return false;
    }

    public static boolean isTypeCompatible(IElementType type, IElementType referenceType) {
        if (type == null || referenceType == null) {
            return false;
        }
        if (type.equals(referenceType)) {
            return true;
        }
        IElementType[] superTypes = type.getAllSuperTypes();
        if (superTypes.length == 0) {
            return false;
        }
        int i = 0;
        while (i < superTypes.length) {
            IElementType superType = superTypes[i];
            if (referenceType.equals(superType)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

