/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProtocolEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.approveRequest(request);
            }
            ArrayList<IElementType> types = new ArrayList<IElementType>(Arrays.asList(type.getAllSuperTypes()));
            types.add(type);
            if (types.contains(umlRTMessageType)) {
                return true;
            }
            return types.contains(ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Generalization")) || types.contains(ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Connector"));
        }
        return super.approveRequest(request);
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        EObject eObject;
        IEditCommandRequest editCommandRequest = request.getEditCommandRequest();
        if (editCommandRequest instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)editCommandRequest;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage");
            if (umlRTMessageType == null || type == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.getBeforeEditContextCommand(request);
            }
            ArrayList<IElementType> types = new ArrayList<IElementType>(Arrays.asList(type.getAllSuperTypes()));
            types.add(type);
            if (types.contains(umlRTMessageType)) {
                GetEditContextCommand command = new GetEditContextCommand(request);
                if (request.getEditContext() instanceof Collaboration) {
                    IHintedType rTMessageTypeIn = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_IN;
                    IHintedType rTMessageTypeOut = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_OUT;
                    IHintedType rTMessageTypeInOut = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_INOUT;
                    if (types.contains(rTMessageTypeIn)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetIn((Collaboration)request.getEditContext()));
                    } else if (types.contains(rTMessageTypeOut)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetOut((Collaboration)request.getEditContext()));
                    } else if (types.contains(rTMessageTypeInOut)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetInOut((Collaboration)request.getEditContext()));
                    } else {
                        return super.getBeforeEditContextCommand(request);
                    }
                }
                return command;
            }
        } else if (editCommandRequest instanceof DestroyElementRequest && (eObject = ((DestroyElementRequest)editCommandRequest).getElementToDestroy()) instanceof Collaboration && ProtocolUtils.isProtocol(eObject).booleanValue()) {
            Package protocolContainerToDestroy = ProtocolUtils.getProtocolContainer((Collaboration)eObject);
            GetEditContextCommand command = new GetEditContextCommand(request);
            command.setEditContext((Object)protocolContainerToDestroy);
            return command;
        }
        return super.getBeforeEditContextCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        return super.getAfterSetCommand(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Collaboration protocol = (Collaboration)request.getElementToConfigure();
        final String name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)"Protocol", (Collection)protocol.eContainer().eContents());
        return new ConfigureElementCommand(request){
            private IProgressMonitor progressMonitor;
            private IAdaptable info;

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.progressMonitor = progressMonitor;
                this.info = info;
                this.createElement(protocol, null, (IElementType)UMLRTElementTypesEnumerator.PROTOCOL_CONTAINER, Relation.PARENT);
                Interface rtMessageSetInt = (Interface)this.createElement(protocol, null, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
                this.setRtMsgKind(rtMessageSetInt, RTMessageKind.IN);
                this.createInterfaceRealization(protocol, null, rtMessageSetInt);
                Interface rtMessageSetOutInt = (Interface)this.createElement(protocol, null, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
                this.setRtMsgKind(rtMessageSetOutInt, RTMessageKind.OUT);
                this.createUsage(protocol, null, rtMessageSetOutInt);
                this.createElement(protocol, "*", (IElementType)UMLElementTypes.ANY_RECEIVE_EVENT, Relation.SIBLING);
                Interface rtMessageSetInOutInt = (Interface)this.createElement(protocol, null, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
                this.setRtMsgKind(rtMessageSetInOutInt, RTMessageKind.IN_OUT);
                this.createInterfaceRealization(protocol, null, rtMessageSetInOutInt);
                this.createUsage(protocol, null, rtMessageSetInOutInt);
                protocol.setName(name);
                return CommandResult.newOKCommandResult((Object)protocol);
            }

            private void createUsage(Collaboration protocol2, String name2, Interface rtMessageSet) throws ExecutionException {
                Usage usageOut = (Usage)this.createElement(protocol2, name2, (IElementType)UMLElementTypes.USAGE, Relation.SIBLING);
                usageOut.getClients().add((Object)protocol2);
                usageOut.getSuppliers().add((Object)rtMessageSet);
            }

            private void createInterfaceRealization(Collaboration protocol2, String name2, Interface rtMessageSetInt) throws ExecutionException {
                InterfaceRealization realization = (InterfaceRealization)this.createElement(protocol2, name2, (IElementType)UMLElementTypes.INTERFACE_REALIZATION, Relation.CHILD);
                realization.setContract(rtMessageSetInt);
                realization.setImplementingClassifier((BehavioredClassifier)protocol2);
            }

            private EObject createElement(Collaboration referenceElement, String name2, IElementType elementType, Relation relation) throws ExecutionException {
                if (referenceElement == null) {
                    throw new ExecutionException("Either the referenceElement or the name parameter is null. ");
                }
                EObject newElement = null;
                CreateElementRequest createElementRequest = new CreateElementRequest((EObject)referenceElement.getNearestPackage(), elementType);
                CreateElementCommand command = new CreateElementCommand(createElementRequest);
                command.execute(this.progressMonitor, this.info);
                newElement = command.getNewElement();
                if (newElement == null) {
                    throw new ExecutionException("Element creation problem for " + elementType.getDisplayName() + ".");
                }
                ((NamedElement)newElement).setName(name2);
                if (relation == Relation.CHILD) {
                    if (elementType == UMLElementTypes.INTERFACE_REALIZATION) {
                        referenceElement.getInterfaceRealizations().add((Object)((InterfaceRealization)newElement));
                    } else {
                        referenceElement.createOwnedAttribute(name2, (Type)newElement);
                    }
                } else if (relation == Relation.SIBLING) {
                    Package nearestPackage = referenceElement.getNearestPackage();
                    nearestPackage.getPackagedElements().add((Object)((PackageableElement)newElement));
                } else if (relation == Relation.PARENT) {
                    Package container = (Package)newElement;
                    EList packagedElements = container.getPackagedElements();
                    packagedElements.add((Object)referenceElement);
                }
                return newElement;
            }

            private void setRtMsgKind(Interface rtMessageSetInt, RTMessageKind kind) {
                RTMessageSet rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)rtMessageSetInt, RTMessageSet.class);
                rtMessageSet.setRtMsgKind(kind);
            }
        };
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        return super.getAfterConfigureCommand(request);
    }

    private static enum Relation {
        CHILD,
        SIBLING,
        PARENT;

    }
}

