/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RTPortEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof SetRequest) {
            SetRequest setRequest = (SetRequest)request;
            EStructuralFeature feature = setRequest.getFeature();
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
                Object newValue = ((SetRequest)request).getValue();
                if (newValue instanceof EObject) {
                    return ProtocolUtils.isProtocol((EObject)newValue) != false;
                }
                return false;
            }
            return super.approveRequest((IEditCommandRequest)setRequest);
        }
        if (request instanceof CreateRelationshipRequest) {
            IElementType type = ((CreateRelationshipRequest)request).getElementType();
            if (type != null && ElementTypeUtils.isTypeCompatible(type, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTConnector"))) {
                return this.checkSourceAndTarget((CreateRelationshipRequest)request);
            }
            return super.approveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected boolean checkSourceAndTarget(CreateRelationshipRequest createRelationshipRequest) {
        EObject source = createRelationshipRequest.getSource();
        EObject target = createRelationshipRequest.getTarget();
        if (source != null) {
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        if (target != null) {
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        return true;
    }

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        ICommand setKindCommand;
        CompositeCommand cc = new CompositeCommand("Set RTPort");
        EStructuralFeature feature = request.getFeature();
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
            String name;
            Object newValue = request.getValue();
            EObject elementToEdit = request.getElementToEdit();
            if (newValue instanceof Type && elementToEdit instanceof Port && ((Port)elementToEdit).getName() == null && (name = ((Type)newValue).getName()) != null && !name.isEmpty()) {
                String newName = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
                cc.add((IUndoableOperation)new SetValueCommand(new SetRequest(request.getElementToEdit(), (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName)));
            }
        }
        if ((setKindCommand = this.getSetKindCommand(request)) != null) {
            cc.add((IUndoableOperation)setKindCommand);
        }
        return cc.isEmpty() ? super.getAfterSetCommand(request) : cc;
    }

    protected ICommand getSetKindCommand(SetRequest request) {
        ICommand cmd = null;
        EObject object = request.getElementToEdit();
        final Object kindParameter = request.getParameter("RTPORT_KIND");
        if (object instanceof Port && kindParameter != null && kindParameter instanceof RTPortKindEnum) {
            final Port rtPort = (Port)object;
            RecordingCommand command = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)object)){

                protected void doExecute() {
                    if (RTPortKindEnum.EXTERNAL.equals(kindParameter)) {
                        RTPortEditHelperAdvice.this.setExternalPort(rtPort);
                    }
                    if (RTPortKindEnum.INTERNAL.equals(kindParameter)) {
                        RTPortEditHelperAdvice.this.setInternalPort(rtPort);
                    }
                    if (RTPortKindEnum.RELAY.equals(kindParameter)) {
                        RTPortEditHelperAdvice.this.setRelayPort(rtPort);
                    }
                    if (RTPortKindEnum.SAP.equals(kindParameter)) {
                        RTPortEditHelperAdvice.this.setSAPPort(rtPort);
                    }
                    if (RTPortKindEnum.SPP.equals(kindParameter)) {
                        RTPortEditHelperAdvice.this.setSPPPort(rtPort);
                    }
                }
            };
            cmd = EMFtoGMFCommandWrapper.wrap((Command)command);
        }
        return cmd;
    }

    protected void setExternalPort(Port externalBehaviorPort) {
        externalBehaviorPort.setIsService(true);
        externalBehaviorPort.setIsBehavior(true);
        RTPort stereotype = (RTPort)UMLUtil.getStereotypeApplication((Element)externalBehaviorPort, RTPort.class);
        stereotype.setIsWired(true);
        stereotype.setIsPublish(false);
        externalBehaviorPort.setVisibility(VisibilityKind.PUBLIC_LITERAL);
    }

    protected void setInternalPort(Port internalBehaviorPort) {
        internalBehaviorPort.setIsService(false);
        internalBehaviorPort.setIsBehavior(true);
        RTPort stereotype = (RTPort)UMLUtil.getStereotypeApplication((Element)internalBehaviorPort, RTPort.class);
        stereotype.setIsWired(true);
        stereotype.setIsPublish(false);
        internalBehaviorPort.setVisibility(VisibilityKind.PROTECTED_LITERAL);
    }

    protected void setRelayPort(Port relayPort) {
        relayPort.setIsService(true);
        relayPort.setIsBehavior(false);
        RTPort stereotype = (RTPort)UMLUtil.getStereotypeApplication((Element)relayPort, RTPort.class);
        stereotype.setIsWired(true);
        stereotype.setIsPublish(false);
        relayPort.setVisibility(VisibilityKind.PUBLIC_LITERAL);
    }

    protected void setSAPPort(Port serviceAccessPoint) {
        serviceAccessPoint.setIsService(false);
        serviceAccessPoint.setIsBehavior(true);
        RTPort stereotype = (RTPort)UMLUtil.getStereotypeApplication((Element)serviceAccessPoint, RTPort.class);
        stereotype.setIsWired(false);
        stereotype.setIsPublish(false);
        serviceAccessPoint.setVisibility(VisibilityKind.PROTECTED_LITERAL);
    }

    protected void setSPPPort(Port serviceProvisionPoint) {
        serviceProvisionPoint.setIsService(true);
        serviceProvisionPoint.setIsBehavior(true);
        RTPort stereotype = (RTPort)UMLUtil.getStereotypeApplication((Element)serviceProvisionPoint, RTPort.class);
        stereotype.setIsWired(false);
        stereotype.setIsPublish(true);
        serviceProvisionPoint.setVisibility(VisibilityKind.PUBLIC_LITERAL);
    }
}

