/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;

public class RTPortUtils {
    public static final String RTPORT_KIND_REQUEST_PARAMETER = "RTPORT_KIND";

    public static boolean isRTPort(EObject eObject) {
        Port port;
        return eObject instanceof Port && RTPortUtils.getStereotype(port = (Port)eObject) != null;
    }

    public boolean isConnected(Port port) {
        return true;
    }

    public static Stereotype getStereotype(Port port) {
        return port.getAppliedStereotype("UMLRealTime::RTPort");
    }

    public static boolean isWired(Port port) {
        return RTPortUtils.getStereotype(port) == null ? false : (Boolean)port.getValue(RTPortUtils.getStereotype(port), "isWired");
    }

    public static boolean isPublish(Port port) {
        return RTPortUtils.getStereotype(port) == null ? false : (Boolean)port.getValue(RTPortUtils.getStereotype(port), "isPublish");
    }

    public static boolean isNotification(Port port) {
        return RTPortUtils.getStereotype(port) == null ? false : (Boolean)port.getValue(RTPortUtils.getStereotype(port), "isNotification");
    }

    public static boolean isBehavior(Port port) {
        return port.isBehavior();
    }

    public static boolean isService(Port port) {
        return port.isService();
    }

    public static boolean isConjugated(Port port) {
        return port.isConjugated();
    }

    public static RTPortKindEnum getKind(Port port) {
        RTPortKindEnum kind = null;
        if (RTPortUtils.getStereotype(port) != null) {
            if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.EXTERNAL;
            } else if (RTPortUtils.isService(port) && RTPortUtils.isBehavior(port) && RTPortUtils.isPublish(port) && !RTPortUtils.isWired(port)) {
                kind = RTPortKindEnum.SPP;
            } else if (RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isService(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.INTERNAL;
            } else if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && !RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.RELAY;
            } else if (RTPortUtils.isBehavior(port) && !RTPortUtils.isWired(port) && !RTPortUtils.isPublish(port) && !RTPortUtils.isService(port)) {
                kind = RTPortKindEnum.SAP;
            }
        }
        return kind;
    }
}

