/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.service;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.NotationFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleDiagramUtils;

/**
 * Specific label provider for UML-RT diagrams, where the name can be null
 */
public class UMLRTNotationFilteredLabelProvider extends NotationFilteredLabelProvider {

	@Override
	protected String getText(EObject element) {
		if (element instanceof Diagram) {
			// if name is null, return the default name of the diagram
			if (UMLRTCapsuleDiagramUtils.isCapsuleDiagram((Diagram) element)) {
				return UMLRTCapsuleDiagramUtils.getDisplayedCapsuleDiagramName((Diagram)element);
			}
			return ((Diagram) element).getName();
		}

		return super.getText(element);
	}
}
