/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.CompositeStructureDiagramEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.uml2.uml.Classifier;

/**
 * Utility method for diagrams
 */
public class UMLRTCapsuleDiagramUtils {

	/**
	 * Returns <code>true</code> if the diagram is a composite capsule diagram
	 * @param diagram the diagram to check
	 * @return <code>true</code> if the diagram is a composite capsule diagram
	 */
	public static boolean isCapsuleDiagram(Diagram diagram) {
		if (diagram == null) {
			return false;
		}
		if (CompositeStructureDiagramEditPart.MODEL_ID.equals(diagram.getType())) {
			// check if it corresponds to the capsule diagram prototype => assume for now that this is a capsule diagram if it is a composite associated to a capsule
			EObject businessElement = diagram.getElement();
			if (businessElement instanceof Classifier && CapsuleUtils.isCapsule((Classifier) businessElement)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Returns the name to be displayed for a capsule diagram, e.g. the name of the associated capsule
	 * 
	 * @param diagram
	 *            the diagram to display
	 * @return the name of the associated capsule or the name of the diagram if no capsule can be found
	 */
	public static String getDisplayedCapsuleDiagramName(Diagram diagram) {
		EObject businessElement = diagram.getElement();
		if (businessElement instanceof Classifier && CapsuleUtils.isCapsule((Classifier) businessElement)) {
			return ((Classifier) businessElement).getName();
		}
		return diagram.getName();
	}

}
