/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.provider;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.CallEventUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.InterfaceRealizationUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UsageUtils;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.provider.UMLRTLabelProvider;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.utils.LabelUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Usage;

public class UMLRTFilteredLabelProvider
extends UMLRTLabelProvider
implements IFilteredLabelProvider {
    public boolean accept(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            return false;
        }
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType)) continue;
            IElementMatcher matcher = ((ISpecializationType)type).getMatcher();
            if (matcher != null) {
                if (!matcher.matches(semanticObject)) continue;
                return true;
            }
            Activator.log.debug("no matcher for this element type: " + type);
        }
        if (semanticObject instanceof CallEvent && CallEventUtils.isProtocolMessageCallEvent((CallEvent)((CallEvent)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof Interface && MessageSetUtils.isRTMessageSet((Element)((Interface)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof InterfaceRealization && InterfaceRealizationUtils.isInterfaceRealizationFromProtocol((InterfaceRealization)((InterfaceRealization)semanticObject))) {
            return true;
        }
        return semanticObject instanceof Usage && UsageUtils.isUsageFromProtocol((Usage)((Usage)semanticObject));
    }

    @Override
    public Image getImage(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            Activator.log.debug("Trying to display an UMLRT image for a non UML-RT element");
            return null;
        }
        String matchingTypeMatcher = this.getMatchingType(semanticObject);
        if (matchingTypeMatcher == null) {
            if (semanticObject instanceof Element) {
                return this.baseEMFLabelProvider.getImage((Object)semanticObject);
            }
            return null;
        }
        return super.getImage(element);
    }

    @Override
    public String getText(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (semanticObject == null) {
            return super.getText(element);
        }
        ISpecializationType inMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_IN;
        if (inMessageType != null && inMessageType.getMatcher() != null && inMessageType.getMatcher().matches(semanticObject)) {
            return "in " + super.getText(element);
        }
        ISpecializationType outMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_OUT;
        if (outMessageType != null && outMessageType.getMatcher() != null && outMessageType.getMatcher().matches(semanticObject)) {
            return "out " + super.getText(element);
        }
        ISpecializationType inOutMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_INOUT;
        if (inOutMessageType != null && inOutMessageType.getMatcher() != null && inOutMessageType.getMatcher().matches(semanticObject)) {
            return "inout " + super.getText(element);
        }
        if (semanticObject instanceof CallEvent && CallEventUtils.isProtocolMessageCallEvent((CallEvent)((CallEvent)semanticObject))) {
            return LabelUtils.getCallEventForProtocolMessageLabel((CallEvent)semanticObject, labelProvider);
        }
        if (semanticObject instanceof Package && ProtocolContainerUtils.isProtocolContainer((EObject)semanticObject)) {
            return LabelUtils.getProtocolContainerLabel((Package)semanticObject, labelProvider);
        }
        if (semanticObject instanceof Interface && MessageSetUtils.isRTMessageSet((Element)((Interface)semanticObject))) {
            return LabelUtils.getMessageSetLabel((Interface)semanticObject, labelProvider);
        }
        if (semanticObject instanceof InterfaceRealization && InterfaceRealizationUtils.isInterfaceRealizationFromProtocol((InterfaceRealization)((InterfaceRealization)semanticObject))) {
            return LabelUtils.getInterfaceRealizationLabel((InterfaceRealization)semanticObject, labelProvider);
        }
        if (semanticObject instanceof Usage && UsageUtils.isUsageFromProtocol((Usage)((Usage)semanticObject))) {
            return LabelUtils.getUsageLabel((Usage)semanticObject, labelProvider);
        }
        return super.getText(element);
    }
}

