/*****************************************************************************
 * Copyright (c) 2010, 2015 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 		Celine JANSSENS (ALL4TEC) celine.janssens@all4tec.net - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.util.LinkedHashMap;
import java.util.Map;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.IRealTimeConstants;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartKindObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindObservableValue;
import org.eclipse.uml2.uml.Stereotype;

public class RTStereotypeModelElement extends StereotypeModelElement {


	private EObject stereoApplication;

	public RTStereotypeModelElement(final EObject stereoApplication, final Stereotype stereotype, final EditingDomain domain) {
		super(stereoApplication, stereotype, domain);
		this.stereoApplication = stereoApplication;
	}

	@Override
	protected boolean isFeatureEditable(final String propertyPath) {
		boolean editable = true;

		if (stereoApplication instanceof RTPort) {

			if (IRealTimeConstants.KIND.equals(propertyPath)) {
				editable = true;
			} else if (IRealTimeConstants.NOTIFICATION.equals(propertyPath)) {
				editable = true; // TODO: This method is not updated when values are changed (good value would be when portHelper.isBehavior(port);)
			} else if (IRealTimeConstants.WIRED.equals(propertyPath)) {
				editable = true; // TODO: This method is not updated when values are changed (good value would be when portHelper.isBehavior(port) || portHelper.isConnected(port);)
			} else if (IRealTimeConstants.PUBLISH.equals(propertyPath)) {
				editable = false;
			}
		} else if (stereoApplication instanceof CapsulePart) {
			editable = true;
		} else {
			editable = super.isFeatureEditable(propertyPath);
		}
		return editable;

	}


	@Override
	public IObservable doGetObservable(final String propertyPath) {
		IObservable observe = null;

		// Case of Kind value in the Port RT Property View
		if (IRealTimeConstants.KIND.equals(propertyPath)) {

			if (stereoApplication instanceof RTPort) {
				observe = new PortRTKindObservableValue(stereoApplication, (TransactionalEditingDomain) domain);
			} else if (stereoApplication instanceof CapsulePart) {
				observe = new CapsulePartKindObservableValue(stereoApplication, (TransactionalEditingDomain) domain);

			}

		} else {
			observe = super.doGetObservable(propertyPath);
		}
		return observe;

	}


	/**
	 * The ContentProvider provide the Map of the Enum value, and there Label to the EnumRadio Editor.
	 * 
	 * @see org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement#getContentProvider(java.lang.String)
	 *
	 * @param propertyPath
	 * @return
	 */
	@Override
	public IStaticContentProvider getContentProvider(String propertyPath) {
		IStaticContentProvider provider = null;
		if (IRealTimeConstants.KIND.equals(propertyPath) && stereoApplication instanceof RTPort) {
			Map<Object, String> map = new LinkedHashMap<Object, String>(RTPortKindEnum.values().length);

			map.put(RTPortKindEnum.EXTERNAL, RTPortKindEnum.EXTERNAL.getLabel());
			map.put(RTPortKindEnum.INTERNAL, RTPortKindEnum.INTERNAL.getLabel());
			map.put(RTPortKindEnum.RELAY, RTPortKindEnum.RELAY.getLabel());
			map.put(RTPortKindEnum.SAP, RTPortKindEnum.SAP.getLabel());
			map.put(RTPortKindEnum.SPP, RTPortKindEnum.SPP.getLabel());

			provider = new StaticContentProvider(map.keySet().toArray());

		} else if (IRealTimeConstants.KIND.equals(propertyPath) && stereoApplication instanceof CapsulePart) {
			Map<Object, String> map = new LinkedHashMap<Object, String>(CapsulePartKindEnum.values().length);

			map.put(CapsulePartKindEnum.FIXED, CapsulePartKindEnum.FIXED.getLabel());
			map.put(CapsulePartKindEnum.OPTIONAL, CapsulePartKindEnum.OPTIONAL.getLabel());
			map.put(CapsulePartKindEnum.PLUGIN, CapsulePartKindEnum.PLUGIN.getLabel());

			provider = new StaticContentProvider(map.keySet().toArray());

		} else {
			provider = super.getContentProvider(propertyPath);
		}
		return provider;
	}

}
