/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.databinding.MultiplicityObservableValue;
import org.eclipse.papyrus.uml.tools.util.MultiplicityParser;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * @author Céline JANSSENS
 *
 */
public class CapsulePartMultiplicityObservableValue extends MultiplicityObservableValue {

	/**
	 * Real Time Stereotype Application
	 */
	private EObject application;

	public CapsulePartMultiplicityObservableValue(EObject source, EditingDomain domain) {
		super(source, domain);
		this.application = UMLUtil.getStereotypeApplication((Element) source, CapsulePart.class);

	}



	@Override
	public Command getCommand(Object multiplicityValue) {
		if (application instanceof CapsulePart) {
			if (multiplicityValue instanceof String) {
				int[] multiBounds = MultiplicityParser.getBounds((String) multiplicityValue);
				int lower = multiBounds[0];
				int upper = multiBounds[1];

				// the allowed multiplicity are n..n or 0..n with n greater than 0.
				if ((lower > 0 && lower == upper) || (lower == 0 && upper != 0)) {
					return super.getCommand(multiplicityValue);
				}
			}
		}

		Activator.log.warn(String.format("The multiplicity %s is not valid for a CapsulePart", multiplicityValue)); //$NON-NLS-1$
		return UnexecutableCommand.INSTANCE;
	}

}
