/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.util.MultiplicityParser;
import org.eclipse.papyrus.views.properties.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.views.properties.providers.FeatureContentProvider;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.AbstractElementTypeBasedValueFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartExtendedObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartTypeValueFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.RTPortTypeValueFactory;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTExtModelElement
extends UMLModelElement {
    private Hashtable<Element, UMLModelElement> delegationModelElements = new Hashtable();
    private final String ownedOp = "ownedOperation";
    private final EObject source;

    public UMLRTExtModelElement(EObject source) {
        super(source, (EditingDomain)TransactionUtil.getEditingDomain((EObject)source));
        this.source = source;
    }

    public UMLModelElement getDelegationModelElement(Element element) {
        UMLModelElement delegationModelElement = this.delegationModelElements.get(element);
        if (delegationModelElement == null) {
            delegationModelElement = new UMLModelElement((EObject)element, this.getDomain());
            this.delegationModelElements.put(element, delegationModelElement);
        }
        return delegationModelElement;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getContentProvider("ownedOperation");
        }
        if (propertyPath.contains("RTmultiplicity")) {
            return new StaticContentProvider((Object[])new String[]{MultiplicityParser.ONE, MultiplicityParser.OPTIONAL});
        }
        return super.getContentProvider(propertyPath);
    }

    public boolean isOrdered(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).isOrdered("ownedOperation");
        }
        return super.isOrdered(propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).isMandatory("ownedOperation");
        }
        return super.isMandatory(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getLabelProvider("ownedOperation");
        }
        return super.getLabelProvider(propertyPath);
    }

    public EStructuralFeature getFeature(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getFeature("ownedOperation");
        }
        return super.getFeature(propertyPath);
    }

    public FeaturePath getFeaturePath(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getFeaturePath("ownedOperation");
        }
        return super.getFeaturePath(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        Object observable = null;
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        observable = intf != null ? this.getDelegationModelElement((Element)intf).doGetObservable("ownedOperation") : ("RTmultiplicity".equals(propertyPath) ? new CapsulePartExtendedObservableValue(this.source, this.domain) : super.doGetObservable(propertyPath));
        return observable;
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getValueFactory("ownedOperation");
        }
        if (propertyPath.endsWith("type")) {
            AbstractElementTypeBasedValueFactory factory = null;
            EReference reference = UMLPackage.eINSTANCE.getTypedElement_Type();
            EClass type = reference.getEReferenceType();
            if (this.source instanceof Port) {
                factory = new RTPortTypeValueFactory(reference);
            } else if (this.source instanceof Property) {
                factory = new CapsulePartTypeValueFactory(reference);
            } else {
                return super.getValueFactory(propertyPath);
            }
            factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
            factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
            UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(this.source, reference);
            ResourceSet rs = this.source == null ? null : (this.source.eResource() == null ? null : this.source.eResource().getResourceSet());
            EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)rs, (String)HistoryUtil.getHistoryID((EObject)this.source, (EStructuralFeature)reference, (String)"container"));
            factory.setContainerContentProvider((IStaticContentProvider)provider);
            factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
            return factory;
        }
        return super.getValueFactory(propertyPath);
    }

    protected Interface getInOrInoutOrOutMessageSet(String propertyPath) {
        Interface result = null;
        if (this.source instanceof Collaboration) {
            if (propertyPath.endsWith("Incoming")) {
                result = this.getInterface(RTMessageKind.IN);
            } else if (propertyPath.endsWith("Outgoing")) {
                result = this.getInterface(RTMessageKind.OUT);
            } else if (propertyPath.endsWith("InOut")) {
                result = this.getInterface(RTMessageKind.IN_OUT);
            }
        }
        return result;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean editable = false;
        if (this.source instanceof Port) {
            Port port = (Port)this.source;
            editable = "isService".equals(propertyPath) ? true : ("isBehavior".equals(propertyPath) ? true : ("isConjugated".equals(propertyPath) ? true : ("type".equals(propertyPath) ? true : super.isFeatureEditable(propertyPath))));
        } else if (this.source instanceof Property) {
            editable = UMLUtil.getStereotypeApplication((Element)((Element)this.source), CapsulePart.class) != null ? true : super.isFeatureEditable(propertyPath);
        } else if (this.source instanceof Collaboration) {
            editable = super.isFeatureEditable(propertyPath);
        }
        return editable;
    }

    protected Interface getInterface(RTMessageKind rtMessageKind) {
        Interface result = null;
        Collaboration protocol = (Collaboration)this.source;
        Iterator relationshipIterator = protocol.getSourceDirectedRelationships().iterator();
        while (relationshipIterator.hasNext() && result == null) {
            DirectedRelationship directedRelation = (DirectedRelationship)relationshipIterator.next();
            if (!(directedRelation instanceof Dependency)) continue;
            result = this.getInterfaceFromDepencies(rtMessageKind, directedRelation);
        }
        return result;
    }

    protected Interface getInterfaceFromDepencies(RTMessageKind rtMessageKind, DirectedRelationship directedRelation) {
        Interface matchingInterface = null;
        Dependency dependency = (Dependency)directedRelation;
        Iterator dependencyIterator = dependency.getSuppliers().iterator();
        while (dependencyIterator.hasNext() && matchingInterface == null) {
            Interface interfaceImpl;
            RTMessageSet rtMessageSet;
            NamedElement supplier = (NamedElement)dependencyIterator.next();
            if (!(supplier instanceof Interface) || (rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)(interfaceImpl = (Interface)supplier), RTMessageSet.class)) == null || rtMessageSet.getRtMsgKind() != rtMessageKind) continue;
            matchingInterface = (Interface)supplier;
        }
        return matchingInterface;
    }
}

