/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

class DelegateProgressMonitorInUIThreadAndPreservingFocus
implements IProgressMonitorWithBlocking {
    private ProgressMonitorPart delegate;
    private Display display;

    public DelegateProgressMonitorInUIThreadAndPreservingFocus(ProgressMonitorPart delegate) {
        this.delegate = delegate;
        this.display = delegate.getDisplay();
    }

    private void inUIThread(Runnable r) {
        if (this.display == Display.getCurrent()) {
            if (!this.delegate.isDisposed()) {
                r.run();
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (!this.delegate.isDisposed()) {
                    r.run();
                }
            });
        }
    }

    public void worked(int work) {
        this.inUIThread(() -> this.delegate.worked(work));
    }

    public void subTask(String name) {
        this.inUIThread(() -> this.delegate.subTask(name));
    }

    public void setTaskName(String name) {
        this.inUIThread(() -> this.delegate.setTaskName(name));
    }

    public void setCanceled(boolean value) {
        this.inUIThread(() -> this.delegate.setCanceled(value));
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public void internalWorked(double work) {
        this.inUIThread(() -> this.delegate.internalWorked(work));
    }

    public void done() {
        this.inUIThread(() -> this.delegate.done());
    }

    public void beginTask(String name, int totalWork) {
        this.inUIThread(() -> {
            Point initialSelection = null;
            Control focusControl = Display.getCurrent().getFocusControl();
            if (focusControl != null && focusControl instanceof Combo) {
                initialSelection = ((Combo)focusControl).getSelection();
            }
            this.delegate.beginTask(name, totalWork);
            if (focusControl != null) {
                focusControl.setFocus();
                if (focusControl instanceof Combo && initialSelection != null) {
                    ((Combo)focusControl).setSelection(initialSelection);
                }
            }
        });
    }

    public void setBlocked(IStatus reason) {
        this.inUIThread(() -> this.delegate.setBlocked(reason));
    }

    public void clearBlocked() {
        this.inUIThread(() -> this.delegate.clearBlocked());
    }
}

