/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.revisions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionRange;

public final class RevisionInformation
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private final List<Revision> fRevisions = new ArrayList<Revision>();
    private final List<Revision> fRORevisions = Collections.unmodifiableList(this.fRevisions);
    private List<RevisionRange> fRanges = null;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fInformationPresenterControlCreator;

    public void addRevision(Revision revision) {
        Assert.isLegal((revision != null ? 1 : 0) != 0);
        this.fRevisions.add(revision);
    }

    public List<Revision> getRevisions() {
        return this.fRORevisions;
    }

    public List<RevisionRange> getRanges() {
        if (this.fRanges == null) {
            ArrayList<RevisionRange> ranges = new ArrayList<RevisionRange>(this.fRevisions.size() * 2);
            for (Revision revision : this.fRevisions) {
                ranges.addAll(revision.getRegions());
            }
            Collections.sort(ranges, (r1, r2) -> r1.getStartLine() - r2.getStartLine());
            this.fRanges = Collections.unmodifiableList(ranges);
        }
        return this.fRanges;
    }

    public void applyDiff(Hunk[] hunks) {
        this.fRanges = null;
        for (Revision revision : this.getRevisions()) {
            revision.applyDiff(hunks);
        }
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return this.fHoverControlCreator;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return this.fInformationPresenterControlCreator;
    }

    public void setHoverControlCreator(IInformationControlCreator creator) {
        this.fHoverControlCreator = creator;
    }

    public void setInformationPresenterControlCreator(IInformationControlCreator creator) {
        this.fInformationPresenterControlCreator = creator;
    }
}

