/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;

public abstract class Reader {
    private boolean verbose = false;

    public IProblem parseInstance(String filename) throws ParseFormatException, IOException, ContradictionException {
        InputStream in = null;
        try {
            IProblem problem;
            in = filename.startsWith("http://") ? new URL(filename).openStream() : new FileInputStream(filename);
            if (filename.endsWith(".gz")) {
                in = new GZIPInputStream(in);
            } else if (filename.endsWith(".bz2")) {
                in = Runtime.getRuntime().exec("bunzip2 -c " + filename).getInputStream();
            }
            IProblem iProblem = problem = this.parseInstance(in);
            return iProblem;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (ParseFormatException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ContradictionException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof ContradictionException) {
                throw (ContradictionException)e.getCause();
            }
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public abstract IProblem parseInstance(InputStream var1) throws ParseFormatException, ContradictionException, IOException;

    @Deprecated
    public IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException("Use #parseInstance(InputStream) instead");
    }

    @Deprecated
    public abstract String decode(int[] var1);

    public abstract void decode(int[] var1, PrintWriter var2);

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbosity(boolean b) {
        this.verbose = b;
    }
}

