/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class Questionnaire {
    private static final String EXTENSION_POINT_ID = String.valueOf(SetupUIPlugin.INSTANCE.getSymbolicName()) + ".questionnaire";
    private static Questionnaire instance;
    private static boolean initialized;

    protected Questionnaire() {
    }

    protected abstract void doPerform(Shell var1, boolean var2);

    public static boolean exists() {
        return Questionnaire.get() != null;
    }

    public static void perform(final Shell parentShell, boolean force) {
        if (Display.getCurrent() == null) {
            Questionnaire.performOutsideUI(parentShell, true);
        } else {
            new Thread("Questionnaire"){

                public void run() {
                    Questionnaire.performOutsideUI(parentShell, true);
                }
            }.start();
        }
    }

    private static void performOutsideUI(Shell parentShell, boolean force) {
        Questionnaire questionnaire = Questionnaire.get();
        if (questionnaire != null) {
            questionnaire.doPerform(parentShell, force);
        }
    }

    private static synchronized Questionnaire get() {
        if (!initialized) {
            long topPriority = Long.MAX_VALUE;
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    int priority = Integer.parseInt(configurationElement.getAttribute("priority"));
                    if ((long)priority < topPriority) {
                        instance = (Questionnaire)configurationElement.createExecutableExtension("class");
                        topPriority = priority;
                    }
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
                ++n2;
            }
            initialized = true;
        }
        return instance;
    }
}

