/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.win32.winhttp;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.net.proxy.IProxyData;

public final class ProxyProviderUtil {
    private static int PROXY_DEFAULT_PORT;
    private static int HTTPPROXY_DEFAULT_PORT;
    private static int HTTPSPROXY_DEFAULT_PORT;
    private static int SOCKSPROXY_DEFAULT_PORT;
    private static final Map<String, String> PROXY_TYPE_MAP;
    private static final String PAC_PROXY_TYPE_DIRECT = "DIRECT";
    private static final String PAC_PROXY_TYPE_PROXY = "PROXY";
    private static final String PAC_PROXY_TYPE_SOCKS = "SOCKS";
    private static final String NO_PROXY = "DIRECT";

    static {
        HTTPPROXY_DEFAULT_PORT = PROXY_DEFAULT_PORT = 80;
        HTTPSPROXY_DEFAULT_PORT = 443;
        SOCKSPROXY_DEFAULT_PORT = 1080;
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("DIRECT", "DIRECT");
        temp.put(PAC_PROXY_TYPE_PROXY, "HTTP");
        temp.put(PAC_PROXY_TYPE_SOCKS, PAC_PROXY_TYPE_SOCKS);
        PROXY_TYPE_MAP = Collections.unmodifiableMap(temp);
    }

    private ProxyProviderUtil() {
    }

    public static void fillProxyLists(String proxyList, List<IProxyData> universalProxies, Map<String, List<IProxyData>> protocolSpecificProxies) {
        StringTokenizer tokenizer = new StringTokenizer(proxyList, ";");
        while (tokenizer.hasMoreTokens()) {
            ProxyProviderUtil.createProxy(tokenizer.nextToken(), universalProxies, protocolSpecificProxies);
        }
    }

    private static void createProxy(String proxyDefinition, List<IProxyData> universalProxies, Map<String, List<IProxyData>> protocolSpecificProxies) {
        String protocol = null;
        String host = null;
        int port = 0;
        int urlStart = 0;
        int equalsChar = proxyDefinition.indexOf("=");
        if (equalsChar != -1) {
            protocol = proxyDefinition.substring(0, equalsChar).toUpperCase();
            urlStart = equalsChar + 1;
        }
        try {
            String augmentedURI = proxyDefinition.substring(urlStart);
            if (augmentedURI.indexOf("://") == -1) {
                augmentedURI = "http://" + augmentedURI;
            }
            URI uri = new URI(augmentedURI);
            host = uri.getHost();
            port = uri.getPort() > 0 ? uri.getPort() : ProxyProviderUtil.getProxyDefaultPort(protocol);
        }
        catch (Exception ex) {
            Activator.logError("not a valid proxy definition: '" + proxyDefinition + "'.", ex);
            return;
        }
        if (host == null) {
            Activator.logError("not a valid proxy definition: '" + proxyDefinition + "'.", null);
            return;
        }
        if (protocol == null) {
            universalProxies.add(ProxyProviderUtil.createProxy("HTTP", host, port));
        } else {
            ProxyProviderUtil.addProtocolSpecificProxy(protocolSpecificProxies, protocol, ProxyProviderUtil.createProxy(ProxyProviderUtil.resolveProxyType(protocol), host, port));
        }
    }

    private static int getProxyDefaultPort(String protocol) {
        if (protocol == null) {
            return PROXY_DEFAULT_PORT;
        }
        if ("HTTP".equalsIgnoreCase(protocol)) {
            return HTTPPROXY_DEFAULT_PORT;
        }
        if ("HTTPS".equalsIgnoreCase(protocol)) {
            return HTTPSPROXY_DEFAULT_PORT;
        }
        if (PAC_PROXY_TYPE_SOCKS.equalsIgnoreCase(protocol)) {
            return SOCKSPROXY_DEFAULT_PORT;
        }
        return PROXY_DEFAULT_PORT;
    }

    private static void addProtocolSpecificProxy(Map<String, List<IProxyData>> protocolSpecificProxies, String protocol, IProxyData proxy) {
        List<IProxyData> list = protocolSpecificProxies.get(protocol);
        if (list == null) {
            list = new ArrayList<IProxyData>();
            protocolSpecificProxies.put(protocol, list);
        }
        list.add(proxy);
    }

    private static String resolveProxyType(String protocol) {
        return protocol;
    }

    private static IProxyData createProxy(String scheme, String host, int port) {
        String type = ProxyProviderUtil.resolveProxyType(scheme);
        ProxyData proxy = new ProxyData(type);
        proxy.setHost(host);
        proxy.setPort(port);
        proxy.setSource("WINDOWS_IE");
        return proxy;
    }

    public static List<IProxyData> getProxies(String pacFindProxyForUrlResult) {
        if (pacFindProxyForUrlResult == null || pacFindProxyForUrlResult.trim().length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IProxyData> result = new ArrayList<IProxyData>();
        StringTokenizer scanner = new StringTokenizer(pacFindProxyForUrlResult, ";");
        while (scanner.hasMoreTokens()) {
            String pacProxy = scanner.nextToken().trim();
            IProxyData proxy = ProxyProviderUtil.getProxy(pacProxy);
            if (proxy == null) continue;
            result.add(proxy);
        }
        return result;
    }

    private static IProxyData getProxy(String pacProxy) {
        String hostname;
        StringTokenizer scanner;
        String pacProxyType;
        String proxyType;
        if (pacProxy == null || pacProxy.length() == 0) {
            return null;
        }
        if (!ProxyProviderUtil.startsWithProxyType(pacProxy)) {
            pacProxy = "PROXY " + pacProxy;
        }
        if ((proxyType = PROXY_TYPE_MAP.get(pacProxyType = (scanner = new StringTokenizer(pacProxy)).nextToken())) == null || proxyType.equals("DIRECT")) {
            return null;
        }
        String pacHostnameAndPort = null;
        if (scanner.hasMoreTokens()) {
            pacHostnameAndPort = scanner.nextToken();
        }
        if ((hostname = ProxyProviderUtil.getHostname(pacHostnameAndPort)) != null) {
            int port = ProxyProviderUtil.getPort(pacHostnameAndPort);
            ProxyData proxy = new ProxyData(proxyType);
            proxy.setHost(hostname);
            proxy.setPort(port);
            proxy.setSource("WINDOWS_IE");
            return proxy;
        }
        return null;
    }

    private static boolean startsWithProxyType(String pacProxy) {
        Iterator<String> iter = PROXY_TYPE_MAP.keySet().iterator();
        while (iter.hasNext()) {
            if (!pacProxy.startsWith(iter.next())) continue;
            return true;
        }
        return false;
    }

    private static String getHostname(String pacHostnameAndPort) {
        return pacHostnameAndPort != null ? pacHostnameAndPort.substring(0, pacHostnameAndPort.indexOf(58)) : null;
    }

    private static int getPort(String pacHostnameAndPort) {
        return pacHostnameAndPort != null && pacHostnameAndPort.indexOf(58) > -1 ? Integer.parseInt(pacHostnameAndPort.substring(pacHostnameAndPort.indexOf(58) + 1)) : 0;
    }
}

