/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.impl.tpt.threadpool;

import java.security.AccessControlContext;
import java.security.AccessController;
import org.eclipse.equinox.internal.util.UtilActivator;
import org.eclipse.equinox.internal.util.impl.tpt.ServiceFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.Executor;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.Job;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.ThreadPoolManagerImpl;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.equinox.internal.util.threadpool.ThreadPoolFactory;
import org.eclipse.equinox.internal.util.threadpool.ThreadPoolManager;

public class ThreadPoolFactoryImpl
extends ServiceFactoryImpl
implements ThreadPoolManager,
ThreadPoolFactory {
    public static ThreadPoolManagerImpl threadPool;
    private int limit;
    private int used = 0;
    private Job queue;
    private static int defaultPercent;

    public ThreadPoolFactoryImpl(String bundleName, Log log) {
        super(bundleName, log);
        threadPool = ThreadPoolManagerImpl.getThreadPool();
        defaultPercent = UtilActivator.getInteger("equinox.util.threadpool.percent", 30);
        this.limit = ThreadPoolManagerImpl.tMaximum * defaultPercent / 100;
        if (this.limit == 0) {
            this.limit = 1;
        }
        this.queue = new Job();
    }

    public ThreadPoolFactoryImpl(String bundleName, int size) {
        super(bundleName);
        this.limit = size;
        if (this.limit == 0) {
            this.limit = 1;
        }
        this.queue = new Job();
    }

    public ThreadPoolFactoryImpl(String bundleName) {
        this(bundleName, ThreadPoolManagerImpl.tMaximum * defaultPercent / 100);
    }

    public Object getInstance(String bundleName) {
        if (threadPool == null) {
            throw new RuntimeException("ServiceFactory is currently off!");
        }
        return new ThreadPoolFactoryImpl(bundleName);
    }

    public static void stopThreadPool() {
        ThreadPoolManagerImpl tmp = threadPool;
        threadPool = null;
        tmp.clear();
    }

    public ThreadPoolManager getThreadPool(int size, boolean sizeIsInPercents) {
        if (threadPool == null) {
            throw new RuntimeException("[ThreadPool] ThreadPool is inaccessible");
        }
        if (sizeIsInPercents) {
            size = ThreadPoolManagerImpl.tMaximum * size / 100;
        }
        if (size <= 0) {
            size = 1;
        }
        return new ThreadPoolFactoryImpl(this.bundleName, size);
    }

    public void execute(Runnable job, String name) {
        this.execute(job, 5, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute0(Runnable job, int priority, String name, AccessControlContext acc) {
        ThreadPoolManagerImpl tmp;
        if (job == null || name == null) {
            throw new IllegalArgumentException("the job or the name parameter is/are null");
        }
        if (ServiceFactoryImpl.useNames) {
            name = String.valueOf(name) + this.bundleName;
        }
        if ((tmp = threadPool) != null) {
            Object object = tmp.getSyncMonitor();
            synchronized (object) {
                if (this.used >= this.limit) {
                    if (UtilActivator.LOG_DEBUG) {
                        UtilActivator.log.debug("In Bundle Queue: " + name + ", bundle queue size: " + this.queue.counter, null);
                    }
                    this.queue.addJob(job, name, priority, this, acc);
                    return;
                }
                ++this.used;
            }
        } else {
            throw new RuntimeException("[ThreadPool] ThreadPool is inaccessible");
        }
        tmp.execute(job, priority, name, this, acc);
    }

    public void execute(Runnable job, int priority, String name, AccessControlContext acc) {
        this.execute0(job, priority, name, acc);
    }

    public void execute(Runnable job, int priority, String name) {
        this.execute0(job, priority, name, Log.security() ? AccessController.getContext() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor() {
        ThreadPoolManagerImpl tmp = threadPool;
        if (tmp != null) {
            Object object = tmp.getSyncMonitor();
            synchronized (object) {
                if (this.used < this.limit) {
                    Executor ex = tmp.getExecutor();
                    if (ex != null) {
                        ++this.used;
                    }
                    return ex;
                }
            }
        }
        return null;
    }

    void finished() {
        Job job = this.queue.getJob();
        if (job != null) {
            if (UtilActivator.LOG_DEBUG) {
                UtilActivator.log.debug("To threadpool queue: " + job.name + ", queue size: " + ThreadPoolFactoryImpl.threadPool.waiting.counter, null);
            }
            ThreadPoolFactoryImpl.threadPool.waiting.addJob(job);
        } else {
            --this.used;
        }
    }

    public void reset() {
        if (threadPool != null) {
            threadPool.reset();
        }
    }
}

