/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationPackage;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableCommandHelper
implements IViewTypeHelper {
    private Map<PapyrusView, TableViewPrototype> cache;

    public ViewPrototype getPrototypeFor(PapyrusView configuration) {
        if (!(configuration instanceof PapyrusTable)) {
            return null;
        }
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusView, TableViewPrototype>();
        }
        if (this.cache.containsKey(configuration)) {
            return this.cache.get(configuration);
        }
        TableViewPrototype proto = new TableViewPrototype((PapyrusTable)configuration);
        this.cache.put(configuration, proto);
        return proto;
    }

    public boolean isSupported(EClass type) {
        return type == ConfigurationPackage.eINSTANCE.getPapyrusTable();
    }

    public boolean isSupported(EObject view) {
        if (!(view instanceof Table)) {
            return false;
        }
        Table table = (Table)view;
        return table.getPrototype() instanceof PapyrusTable;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        return this.getPrototypeFor((PapyrusView)((Table)view).getPrototype());
    }
}

