/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutCategoryData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.ui.AlgorithmContentProvider;
import org.eclipse.elk.core.ui.Messages;
import org.eclipse.elk.core.util.Maybe;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AlgorithmSelectionDialog
extends Dialog {
    private String layouterHint;
    private Label displayNameLabel;
    private Label descriptionLabel;
    private Label imageLabel;
    private ISelectionProvider selectionProvider;
    private final Map<ILayoutMetaData, Image> imageCache = new HashMap<ILayoutMetaData, Image>();
    private List<ISelectionChangedListener> selectionListeners = new LinkedList<ISelectionChangedListener>();
    private static final int SELECTION_WIDTH = 220;
    private static final int DESCRIPTION_WIDTH = 300;
    private static final int DESCR_SPACING = 12;

    public AlgorithmSelectionDialog(Shell parentShell, String currentHint) {
        super(parentShell);
        this.layouterHint = currentHint;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("kiml.ui.58"));
    }

    public void addAlgorithmSelectionListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(listener);
        } else {
            this.selectionListeners.add(listener);
        }
    }

    public void removeAlgorithmSelectionListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(listener);
        } else {
            this.selectionListeners.remove(listener);
        }
    }

    public boolean close() {
        this.imageLabel.setImage(null);
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        this.imageCache.clear();
        return super.close();
    }

    private void updateValue(ILayoutMetaData layoutData) {
        this.layouterHint = layoutData.getId();
        String name = layoutData.getName();
        if (name == null || name.length() == 0) {
            name = layoutData instanceof LayoutAlgorithmData ? Messages.getString("kiml.ui.61") : Messages.getString("kiml.ui.8");
        }
        this.displayNameLabel.setText(name);
        String description = layoutData.getDescription();
        if (description == null || description.length() == 0) {
            description = Messages.getString("kiml.ui.60");
        }
        this.descriptionLabel.setText(description);
        Image image = this.imageCache.get(layoutData);
        if (image == null && layoutData instanceof LayoutAlgorithmData) {
            String bundleId;
            ImageDescriptor imageDescriptor;
            String path = ((LayoutAlgorithmData)layoutData).getPreviewImagePath();
            int lastDotIndex = layoutData.getId().lastIndexOf(46);
            if (path != null && lastDotIndex > 0 && (imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)(bundleId = layoutData.getId().substring(0, lastDotIndex)), (String)path)) != null && (image = imageDescriptor.createImage(false)) != null) {
                this.imageCache.put(layoutData, image);
            }
        }
        this.imageLabel.setImage(image);
        this.imageLabel.getParent().layout();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        this.createSelectionTree(composite);
        this.createDescriptionArea(composite);
        if (this.layouterHint != null) {
            LayoutMetaDataService layoutServices = LayoutMetaDataService.getInstance();
            LayoutAlgorithmData layoutData = layoutServices.getAlgorithmData(this.layouterHint);
            if (layoutData == null) {
                layoutData = layoutServices.getCategoryData(this.layouterHint);
            }
            if (layoutData != null) {
                this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)layoutData));
            }
        }
        return composite;
    }

    private Control createSelectionTree(Composite parent) {
        Composite composite = new Composite(parent, 0);
        final Text filterText = new Text(composite, 2048);
        filterText.setText(Messages.getString("kiml.ui.59"));
        filterText.setLayoutData((Object)new GridData(4, 128, true, false));
        filterText.setForeground(parent.getDisplay().getSystemColor(15));
        final TreeViewer treeViewer = new TreeViewer(composite, 2564);
        final AlgorithmContentProvider contentProvider = new AlgorithmContentProvider();
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LayoutAlgorithmData) {
                    LayoutAlgorithmData algoData = (LayoutAlgorithmData)element;
                    String bundleName = algoData.getBundleName();
                    if (bundleName == null) {
                        return algoData.getName();
                    }
                    return String.valueOf(algoData.getName()) + " (" + bundleName + ")";
                }
                if (element instanceof LayoutCategoryData) {
                    LayoutCategoryData typeData = (LayoutCategoryData)element;
                    if (typeData.getName() == null) {
                        return "Other";
                    }
                    return typeData.getName();
                }
                return super.getText(element);
            }
        });
        treeViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof LayoutCategoryData) {
                    LayoutCategoryData typeData = (LayoutCategoryData)element;
                    return typeData.getId().length() == 0 ? 1 : 0;
                }
                return super.category(element);
            }
        });
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setInput((Object)LayoutMetaDataService.getInstance());
        treeViewer.expandAll();
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AlgorithmSelectionDialog.this.okPressed();
            }
        });
        final Maybe filterChanged = new Maybe((Object)Boolean.FALSE);
        final Maybe filterLeft = new Maybe((Object)Boolean.FALSE);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!((Boolean)filterChanged.get()).booleanValue()) {
                    filterChanged.set((Object)Boolean.TRUE);
                    filterText.setForeground(null);
                    int pos = filterText.getCaretPosition();
                    String newText = filterText.getText(pos - 1, pos - 1);
                    filterText.setText(newText);
                    filterText.setSelection(pos);
                } else {
                    contentProvider.updateFilter(filterText.getText());
                    treeViewer.refresh();
                    treeViewer.expandAll();
                    ILayoutMetaData selected = contentProvider.getBestFilterMatch();
                    if (selected != null) {
                        treeViewer.setSelection((ISelection)new StructuredSelection((Object)selected));
                    }
                }
            }
        });
        filterText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (((Boolean)filterLeft.get()).booleanValue() && !((Boolean)filterChanged.get()).booleanValue()) {
                    filterChanged.set((Object)Boolean.TRUE);
                    filterText.setForeground(null);
                    filterText.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                filterLeft.set((Object)Boolean.TRUE);
            }
        });
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return contentProvider.applyFilter(element);
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof ILayoutMetaData) {
                    AlgorithmSelectionDialog.this.updateValue((ILayoutMetaData)element);
                }
            }
        });
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 220;
        composite.setLayoutData((Object)gridData);
        this.selectionProvider = treeViewer;
        for (ISelectionChangedListener listener : this.selectionListeners) {
            this.selectionProvider.addSelectionChangedListener(listener);
        }
        return composite;
    }

    private Control createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.displayNameLabel = new Label(composite, 0);
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)parent.getFont());
        fontDescriptor = fontDescriptor.increaseHeight(2).setStyle(1);
        this.displayNameLabel.setFont(fontDescriptor.createFont((Device)parent.getDisplay()));
        this.displayNameLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.descriptionLabel = new Label(composite, 64);
        GridData descriptionLayoutData = new GridData(4, 4, true, true);
        descriptionLayoutData.widthHint = 300;
        this.descriptionLabel.setLayoutData((Object)descriptionLayoutData);
        this.imageLabel = new Label(composite, 0);
        GridData imageLayoutData = new GridData(4, 1024, true, false);
        this.imageLabel.setLayoutData((Object)imageLayoutData);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.verticalSpacing = 12;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    public String getSelectedHint() {
        return this.layouterHint;
    }
}

