/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.views;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.LayoutOptionValidator;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.elk.core.service.LayoutConfigurationManager;
import org.eclipse.elk.core.ui.views.LayoutPropertySource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class LayoutPropertySourceProvider
implements IPropertySourceProvider {
    @Inject(optional=true)
    private ILayoutConfigurationStore.Provider configurationStoreProvider;
    @Inject
    private LayoutConfigurationManager configManager;
    @Inject
    private Provider<LayoutOptionValidator> layoutOptionValidatorProvider;
    private IWorkbenchPart workbenchPart;
    private final List<ILayoutConfigurationStore> configStores = new LinkedList<ILayoutConfigurationStore>();

    public IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public void setWorkbenchPart(IWorkbenchPart theworkbenchPart) {
        this.workbenchPart = theworkbenchPart;
    }

    public List<ILayoutConfigurationStore> getConfigurationStores() {
        return this.configStores;
    }

    public LayoutConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    public IPropertySource getPropertySource(Object object) {
        ILayoutConfigurationStore config;
        if (this.configurationStoreProvider != null && (config = this.configurationStoreProvider.get(this.workbenchPart, object)) != null) {
            this.configStores.add(config);
            return this.createPropertySource(config);
        }
        return null;
    }

    protected IPropertySource createPropertySource(ILayoutConfigurationStore config) {
        LayoutPropertySource result = new LayoutPropertySource(config, this.getConfigurationManager());
        result.setValidator((LayoutOptionValidator)this.layoutOptionValidatorProvider.get());
        return result;
    }
}

