/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.profile.Codegen.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.CodegenFactory;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.CodegenPackage;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GenerationModeKind;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GeneratorHint;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Language;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Project;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.impl.GeneratorHintImpl;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.impl.LanguageImpl;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.impl.NoCodeGenImpl;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.impl.ProjectImpl;

public class CodegenFactoryImpl
extends EFactoryImpl
implements CodegenFactory {
    public static CodegenFactory init() {
        try {
            CodegenFactory theCodegenFactory = (CodegenFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/Codegen/1");
            if (theCodegenFactory != null) {
                return theCodegenFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CodegenFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProject();
            }
            case 1: {
                return this.createGeneratorHint();
            }
            case 2: {
                return this.createLanguage();
            }
            case 3: {
                return this.createNoCodeGen();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createGenerationModeKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertGenerationModeKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Project createProject() {
        ProjectImpl project = new ProjectImpl();
        return project;
    }

    @Override
    public GeneratorHint createGeneratorHint() {
        GeneratorHintImpl generatorHint = new GeneratorHintImpl();
        return generatorHint;
    }

    @Override
    public Language createLanguage() {
        LanguageImpl language = new LanguageImpl();
        return language;
    }

    @Override
    public NoCodeGen createNoCodeGen() {
        NoCodeGenImpl noCodeGen = new NoCodeGenImpl();
        return noCodeGen;
    }

    public GenerationModeKind createGenerationModeKindFromString(EDataType eDataType, String initialValue) {
        GenerationModeKind result = GenerationModeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertGenerationModeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public CodegenPackage getCodegenPackage() {
        return (CodegenPackage)this.getEPackage();
    }

    @Deprecated
    public static CodegenPackage getPackage() {
        return CodegenPackage.eINSTANCE;
    }
}

