/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class GenUtils {
    public static final String NL = System.getProperties().getProperty("line.separator");

    public static TemplateBinding getTemplateBinding(Classifier current) {
        TemplateBinding binding = null;
        if (current.getTemplateBindings().size() == 1) {
            binding = (TemplateBinding)current.getTemplateBindings().get(0);
        }
        return binding;
    }

    public static boolean isTemplateBoundElement(Classifier cl) {
        boolean result = false;
        EList tbs = cl.getTemplateBindings();
        if (tbs.size() > 0) {
            for (TemplateBinding tb : tbs) {
                boolean bl = result = tb.getBoundElement() == cl;
            }
        }
        return result;
    }

    public static String getTemplateName(TemplateParameter templateParam) {
        String name = "";
        ParameterableElement pElt = templateParam.getParameteredElement();
        name = pElt != null && pElt instanceof NamedElement ? ((NamedElement)pElt).getName() : "undefined";
        return name;
    }

    public static Collection<TemplateParameter> getTemplateParameters(Classifier classifier) {
        ArrayList<TemplateParameter> params = new ArrayList<TemplateParameter>();
        TemplateSignature ts = classifier.getOwnedTemplateSignature();
        if (ts != null) {
            params.addAll((Collection<TemplateParameter>)ts.getOwnedParameters());
        }
        return params;
    }

    public static Collection<ParameterableElement> getTemplateParameteredElements(Classifier classifier) {
        ArrayList<ParameterableElement> params = new ArrayList<ParameterableElement>();
        TemplateSignature ts = classifier.getOwnedTemplateSignature();
        if (ts != null) {
            for (TemplateParameter tp : ts.getOwnedParameters()) {
                if (tp == null) continue;
                params.add(tp.getParameteredElement());
            }
        }
        return params;
    }

    public static EList<Classifier> getTypesViaAttributes(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Property currentAttribute : current.getAttributes()) {
            Type type = currentAttribute.getType();
            GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
        }
        return result;
    }

    public static EList<Classifier> getDirectTypesViaAttributes(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Property currentAttribute : current.getAttributes()) {
            Type type = currentAttribute.getType();
            GenUtils.addClosestOwnerType((Element)type, (EList<Classifier>)result);
        }
        return result;
    }

    public static EList<Classifier> getTypesViaAttributes(Classifier current, EList<Class<? extends EObject>> excludedStereotypes, EList<Class<? extends EObject>> includedStereotypes, boolean bypassForInnerClassifiers, boolean noSharedAggregation) {
        UniqueEList result = new UniqueEList();
        for (Property currentAttribute : current.getAttributes()) {
            Type type = currentAttribute.getType();
            if (type == null) continue;
            if (bypassForInnerClassifiers && !(type.getOwner() instanceof Package)) {
                GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
                continue;
            }
            boolean ok = true;
            if (noSharedAggregation && currentAttribute.getAggregation() == AggregationKind.SHARED_LITERAL) {
                ok = false;
            }
            if (ok && excludedStereotypes != null && GenUtils.hasAnyStereotype((Element)currentAttribute, excludedStereotypes)) {
                ok = false;
            }
            if (ok && includedStereotypes != null && !GenUtils.hasAnyStereotype((Element)currentAttribute, includedStereotypes)) {
                ok = false;
            }
            if (!ok) continue;
            GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
        }
        return result;
    }

    public static EList<Classifier> getTypesViaSharedAggregationAttributes(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Property currentAttribute : current.getAttributes()) {
            Type type = currentAttribute.getType();
            if (type == null || currentAttribute.getAggregation() != AggregationKind.SHARED_LITERAL) continue;
            GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
        }
        return result;
    }

    public static EList<Classifier> getTypesViaOperations(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Operation operation : current.getOperations()) {
            for (Parameter param : operation.getOwnedParameters()) {
                Type type = param.getType();
                GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
            }
            for (Type type : operation.getRaisedExceptions()) {
                GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
            }
        }
        return result;
    }

    public static EList<Classifier> getDirectTypesViaOperations(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Operation operation : current.getOperations()) {
            for (Parameter param : operation.getOwnedParameters()) {
                Type type = param.getType();
                GenUtils.addClosestOwnerType((Element)type, (EList<Classifier>)result);
            }
            for (Type type : operation.getRaisedExceptions()) {
                GenUtils.addClosestOwnerType((Element)type, (EList<Classifier>)result);
            }
        }
        return result;
    }

    public static EList<Classifier> getTypesViaOperations(Classifier current, EList<Class<? extends EObject>> excludedOperationStereotypes, EList<Class<? extends EObject>> includedOperationStereotypes, EList<Class<? extends EObject>> excludedParameterStereotypes, EList<Class<? extends EObject>> includedParameterStereotypes, boolean bypassForInnerClassifiers) {
        UniqueEList result = new UniqueEList();
        for (Operation operation : current.getOperations()) {
            boolean operationOk;
            boolean ok = true;
            if (excludedOperationStereotypes != null && GenUtils.hasAnyStereotype((Element)operation, excludedOperationStereotypes)) {
                ok = false;
            }
            if (includedOperationStereotypes != null && !GenUtils.hasAnyStereotype((Element)operation, includedOperationStereotypes)) {
                ok = false;
            }
            if (!(operationOk = ok) && !bypassForInnerClassifiers) continue;
            for (Parameter param : operation.getOwnedParameters()) {
                Type type = param.getType();
                if (type == null) continue;
                if (bypassForInnerClassifiers && !(type.getOwner() instanceof Package)) {
                    GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
                    continue;
                }
                if (!operationOk) continue;
                ok = true;
                if (excludedParameterStereotypes != null && GenUtils.hasAnyStereotype((Element)param, excludedParameterStereotypes)) {
                    ok = false;
                }
                if (includedParameterStereotypes != null && !GenUtils.hasAnyStereotype((Element)param, includedParameterStereotypes)) {
                    ok = false;
                }
                if (!ok) continue;
                GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
            }
        }
        return result;
    }

    public static EList<Classifier> getTypesViaOpaqueBehaviors(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Element element : current.getOwnedElements()) {
            OpaqueBehavior opaqueBehavior;
            if (!(element instanceof OpaqueBehavior) || (opaqueBehavior = (OpaqueBehavior)element).getSpecification() != null) continue;
            for (Parameter param : opaqueBehavior.getOwnedParameters()) {
                Type type = param.getType();
                GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
            }
        }
        return result;
    }

    public static EList<Classifier> getTypesViaOpaqueBehaviors(Classifier current, EList<Class<? extends EObject>> excludedOperationStereotypes, EList<Class<? extends EObject>> includedOperationStereotypes, EList<Class<? extends EObject>> excludedParameterStereotypes, EList<Class<? extends EObject>> includedParameterStereotypes, boolean bypassForInnerClassifiers) {
        UniqueEList result = new UniqueEList();
        for (Element element : current.getOwnedElements()) {
            OpaqueBehavior opaqueBehavior;
            if (!(element instanceof OpaqueBehavior) || (opaqueBehavior = (OpaqueBehavior)element).getSpecification() != null) continue;
            boolean ok = true;
            if (excludedOperationStereotypes != null && GenUtils.hasAnyStereotype((Element)opaqueBehavior, excludedOperationStereotypes)) {
                ok = false;
            }
            if (includedOperationStereotypes != null && !GenUtils.hasAnyStereotype((Element)opaqueBehavior, includedOperationStereotypes)) {
                ok = false;
            }
            if (!ok) continue;
            for (Parameter param : opaqueBehavior.getOwnedParameters()) {
                Type type = param.getType();
                if (type == null) continue;
                if (bypassForInnerClassifiers && !(type.getOwner() instanceof Package)) {
                    GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
                    continue;
                }
                ok = true;
                if (excludedParameterStereotypes != null && GenUtils.hasAnyStereotype((Element)param, excludedParameterStereotypes)) {
                    ok = false;
                }
                if (includedParameterStereotypes != null && !GenUtils.hasAnyStereotype((Element)param, includedParameterStereotypes)) {
                    ok = false;
                }
                if (!ok) continue;
                GenUtils.addFarthestOwnerType((Element)type, (EList<Classifier>)result);
            }
        }
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypes(Classifier current) {
        UniqueEList result = new UniqueEList();
        result.addAll(GenUtils.getInnerClassifierTypesViaAttributes(current));
        result.addAll(GenUtils.getInnerClassifierTypesViaOperations(current));
        return result;
    }

    public static EList<Classifier> getDirectInnerClassifierTypes(Classifier current) {
        UniqueEList result = new UniqueEList();
        result.addAll(GenUtils.getDirectInnerClassifierTypesViaAttributes(current));
        result.addAll(GenUtils.getDirectInnerClassifierTypesViaOperations(current));
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypesViaAttributes(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getTypesViaAttributes((Classifier)ownedElement));
        }
        return result;
    }

    public static EList<Classifier> getDirectInnerClassifierTypesViaAttributes(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getDirectTypesViaAttributes((Classifier)ownedElement));
        }
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypesViaAttributes(Classifier current, EList<Class<? extends EObject>> excludedStereotypes, EList<Class<? extends EObject>> includedStereotypes, boolean bypassForInnerClassifiers, boolean noSharedAggregation) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getTypesViaAttributes((Classifier)ownedElement, excludedStereotypes, includedStereotypes, bypassForInnerClassifiers, noSharedAggregation));
        }
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypesViaSharedAggregationAttributes(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getTypesViaSharedAggregationAttributes((Classifier)ownedElement));
        }
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypesViaOperations(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getTypesViaOperations((Classifier)ownedElement));
        }
        return result;
    }

    public static EList<Classifier> getDirectInnerClassifierTypesViaOperations(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getDirectTypesViaOperations((Classifier)ownedElement));
        }
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypesViaOperations(Classifier current, EList<Class<? extends EObject>> excludedOperationStereotypes, EList<Class<? extends EObject>> includedOperationStereotypes, EList<Class<? extends EObject>> excludedParameterStereotypes, EList<Class<? extends EObject>> includedParameterStereotypes, boolean bypassForInnerClassifiers) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getTypesViaOperations((Classifier)ownedElement, excludedOperationStereotypes, includedOperationStereotypes, excludedParameterStereotypes, includedParameterStereotypes, bypassForInnerClassifiers));
        }
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypesViaOpaqueBehaviors(Classifier current) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getTypesViaOpaqueBehaviors((Classifier)ownedElement));
        }
        return result;
    }

    public static EList<Classifier> getInnerClassifierTypesViaOpaqueBehaviors(Classifier current, EList<Class<? extends EObject>> excludedOperationStereotypes, EList<Class<? extends EObject>> includedOperationStereotypes, EList<Class<? extends EObject>> excludedParameterStereotypes, EList<Class<? extends EObject>> includedParameterStereotypes, boolean bypassForInnerClassifiers) {
        UniqueEList result = new UniqueEList();
        for (Element ownedElement : current.allOwnedElements()) {
            if (!(ownedElement instanceof Classifier)) continue;
            result.addAll(GenUtils.getTypesViaOpaqueBehaviors((Classifier)ownedElement, excludedOperationStereotypes, includedOperationStereotypes, excludedParameterStereotypes, includedParameterStereotypes, bypassForInnerClassifiers));
        }
        return result;
    }

    public static EList<Classifier> getTypesViaRelationships(Classifier current) {
        UniqueEList classifiers = new UniqueEList();
        for (DirectedRelationship relationship : current.getSourceDirectedRelationships()) {
            if (relationship.getTargets().size() <= 0) continue;
            Element element = (Element)relationship.getTargets().get(0);
            GenUtils.addFarthestOwnerType(element, (EList<Classifier>)classifiers);
        }
        return classifiers;
    }

    public static EList<Classifier> getTypesViaDependencies(Classifier current) {
        UniqueEList classifiers = new UniqueEList();
        for (DirectedRelationship relationship : current.getSourceDirectedRelationships()) {
            if (!(relationship instanceof Dependency) || relationship.getTargets().size() <= 0) continue;
            Element element = (Element)relationship.getTargets().get(0);
            GenUtils.addFarthestOwnerType(element, (EList<Classifier>)classifiers);
        }
        return classifiers;
    }

    public static EList<Classifier> getDirectTypesViaDependencies(Classifier current) {
        UniqueEList classifiers = new UniqueEList();
        for (DirectedRelationship relationship : current.getSourceDirectedRelationships()) {
            if (!(relationship instanceof Dependency) || relationship.getTargets().size() <= 0) continue;
            Element element = (Element)relationship.getTargets().get(0);
            GenUtils.addClosestOwnerType(element, (EList<Classifier>)classifiers);
        }
        return classifiers;
    }

    public static EList<Classifier> getTypesViaRelationshipsNoDeps(Classifier current) {
        UniqueEList classifiers = new UniqueEList();
        for (DirectedRelationship relationship : current.getSourceDirectedRelationships()) {
            if (relationship instanceof Dependency || relationship.getTargets().size() <= 0) continue;
            Element element = (Element)relationship.getTargets().get(0);
            GenUtils.addFarthestOwnerType(element, (EList<Classifier>)classifiers);
        }
        for (Element owned : current.getOwnedElements()) {
            if (!(owned instanceof Classifier)) continue;
            classifiers.addAll(GenUtils.getTypesViaRelationshipsNoDeps((Classifier)owned));
        }
        return classifiers;
    }

    public static EList<Classifier> getDirectTypesViaRelationshipsNoDeps(Classifier current) {
        UniqueEList classifiers = new UniqueEList();
        for (DirectedRelationship relationship : current.getSourceDirectedRelationships()) {
            if (relationship instanceof Dependency || relationship.getTargets().size() <= 0) continue;
            Element element = (Element)relationship.getTargets().get(0);
            GenUtils.addClosestOwnerType(element, (EList<Classifier>)classifiers);
        }
        for (Element owned : current.getOwnedElements()) {
            if (!(owned instanceof Classifier)) continue;
            classifiers.addAll(GenUtils.getDirectTypesViaRelationshipsNoDeps((Classifier)owned));
        }
        return classifiers;
    }

    public static String getFullName(NamedElement ne) {
        return ne.getQualifiedName().replace("::", "_");
    }

    public static String getFullName(NamedElement ne, String separator) {
        return ne.getQualifiedName().replace("::", separator);
    }

    public static String getFullNameUC(NamedElement ne) {
        return ne.getQualifiedName().replace("::", "_").toUpperCase();
    }

    public static String getComments(Element element) {
        String commentText = "";
        for (Comment comment : element.getOwnedComments()) {
            commentText = String.valueOf(commentText) + GenUtils.cleanCR(comment.getBody());
        }
        return commentText;
    }

    public static EList<Package> getUsedPackages(Package pkg) {
        UniqueEList result = new UniqueEList();
        for (Element depElement : pkg.getClientDependencies()) {
            if (!(depElement instanceof Package)) continue;
            result.add((Object)((Package)depElement));
        }
        return result;
    }

    public static EList<Classifier> getUsedClassifiers(Classifier cls) {
        BasicEList result = new BasicEList();
        for (Element depElement : cls.getClientDependencies()) {
            GenUtils.addFarthestOwnerType(depElement, (EList<Classifier>)result);
        }
        return result;
    }

    public static void addFarthestOwnerType(Element element, EList<Classifier> result) {
        if (element == null || result == null) {
            return;
        }
        if (element.getOwner() instanceof Package && element instanceof Classifier) {
            result.add((Object)((Classifier)element));
        } else {
            GenUtils.addFarthestOwnerType(element.getOwner(), result);
        }
    }

    public static void addClosestOwnerType(Element element, EList<Classifier> result) {
        if (element == null || result == null) {
            return;
        }
        if (element instanceof Classifier) {
            result.add((Object)((Classifier)element));
        } else {
            GenUtils.addClosestOwnerType(element.getOwner(), result);
        }
    }

    public static String getNestedOperationFarthestClassifierOwnerNamespace(Operation op) {
        StringBuffer buffer = new StringBuffer("");
        if (op != null && op.getOwner() instanceof Classifier) {
            GenUtils.getFarthestOwnerNamespace(op.getOwner(), buffer);
        }
        return buffer.toString();
    }

    public static String getNestedBehaviorFarthestClassifierOwnerNamespace(OpaqueBehavior behavior) {
        StringBuffer buffer = new StringBuffer("");
        if (behavior != null && behavior.getOwner() instanceof Classifier) {
            GenUtils.getFarthestOwnerNamespace(behavior.getOwner(), buffer);
        }
        return buffer.toString();
    }

    private static void getFarthestOwnerNamespace(Element element, StringBuffer result) {
        if (element == null || result == null) {
            return;
        }
        if (element.getOwner() instanceof Package) {
            result.insert(0, ((Classifier)element).getName());
        } else {
            result.insert(0, "::" + ((Classifier)element).getName());
            GenUtils.getFarthestOwnerNamespace(element.getOwner(), result);
        }
    }

    public static String getFullPath(Package pkg) {
        return pkg.getQualifiedName().replace("::", "/");
    }

    public static String getFullPath(Package pkg, String seperator) {
        return pkg.getQualifiedName().replace("::", seperator);
    }

    public static boolean hasStereotype(Element element, String stereotName) {
        return element.getAppliedStereotype(stereotName) != null;
    }

    public static boolean hasStereotype(Element element, Class<? extends EObject> clazz) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!clazz.isAssignableFrom(stereoApplication.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllStereotypes(Element element, EList<Class<? extends EObject>> stereotypes) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            for (Class stereotype : stereotypes) {
                if (stereotype.isAssignableFrom(stereoApplication.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasAnyStereotype(Element element, EList<Class<? extends EObject>> stereotypes) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            for (Class stereotype : stereotypes) {
                if (!stereotype.isAssignableFrom(stereoApplication.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasStereotypeA(Element element, EClass definition) {
        if (element == null) {
            return false;
        }
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (stereoApplication.eClass() != definition) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStereotypeTree(Element elt, Class<? extends EObject> clazz) {
        if (GenUtils.hasStereotype(elt, clazz)) {
            return true;
        }
        Element owner = elt.getOwner();
        if (owner != null) {
            return GenUtils.hasStereotypeTree(owner, clazz);
        }
        return false;
    }

    public static boolean hasStereotypeTree(Element elt, EClass definition) {
        if (GenUtils.hasStereotypeA(elt, definition)) {
            return true;
        }
        Element owner = elt.getOwner();
        if (owner != null) {
            return GenUtils.hasStereotypeTree(owner, definition);
        }
        return false;
    }

    public static <T extends EObject> T getApplicationTree(Element elt, Class<T> clazz) {
        EObject application = UMLUtil.getStereotypeApplication((Element)elt, clazz);
        if (application != null) {
            return (T)application;
        }
        Element owner = elt.getOwner();
        if (owner != null) {
            return GenUtils.getApplicationTree(owner, clazz);
        }
        return null;
    }

    public static EObject getApplicationTreeA(Element elt, EClass definition) {
        EObject application = GenUtils.getApplicationA(elt, definition);
        if (application != null) {
            return application;
        }
        Element owner = elt.getOwner();
        if (owner != null) {
            return GenUtils.getApplicationTreeA(owner, definition);
        }
        return null;
    }

    public static EObject getApplicationA(Element element, EClass eClass) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (stereoApplication.eClass() != eClass) continue;
            return stereoApplication;
        }
        return null;
    }

    public static String getBody(Operation operation, Pattern selectedLanguages) {
        for (Behavior behavior : operation.getMethods()) {
            if (!(behavior instanceof OpaqueBehavior)) continue;
            return GenUtils.getBodyFromOB((OpaqueBehavior)behavior, selectedLanguages);
        }
        return "";
    }

    public static String getBodyFromOB(OpaqueBehavior ob, Pattern selectedLanguages) {
        Iterator bodies = ob.getBodies().iterator();
        for (String language : ob.getLanguages()) {
            if (!bodies.hasNext()) continue;
            String body = (String)bodies.next();
            Matcher matcher = selectedLanguages.matcher(language);
            if (!matcher.matches()) continue;
            return GenUtils.cleanCR(body);
        }
        return "";
    }

    public static String cleanCR(String str) {
        if (str == null) {
            return "// <null>";
        }
        return str.replace("\r", "");
    }

    public static String maskNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String getRelativePath(NamedElement ne1, NamedElement ne2) {
        EList ne1namespaces = ne1.allNamespaces();
        String path = "";
        for (Namespace ns : ne2.allNamespaces()) {
            if (ne1namespaces.contains((Object)ns)) {
                return ne2.getName();
            }
            path = String.valueOf(path) + "../";
        }
        return path;
    }

    public static Parameter returnResult(Behavior behavior) {
        for (Parameter parameter : behavior.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            return parameter;
        }
        return null;
    }
}

