/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.elk;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.elk.conn.gmf.GmfLayoutConfigurationStore;
import org.eclipse.elk.conn.gmf.GmfLayoutSetup;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.elk.PapyrusDiagramLayoutConnector;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.ui.IEditorPart;

public class PapyrusLayoutSetup
extends GmfLayoutSetup {
    public boolean supports(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object o : collection) {
                if (!this.isPapyrusEditPart(o)) continue;
                return true;
            }
            return false;
        }
        return this.getDiagramEditor(object) != null || this.isPapyrusEditPart(object);
    }

    protected boolean isPapyrusEditPart(Object o) {
        if (o instanceof IGraphicalEditPart) {
            try {
                return ServiceUtilsForEditPart.getInstance().getServiceRegistry((EditPart)((IGraphicalEditPart)o)) != null;
            }
            catch (ServiceException ex) {
                return false;
            }
        }
        return false;
    }

    protected DiagramEditor getDiagramEditor(Object object) {
        if (object == null) {
            return null;
        }
        IEditorPart activeEditor = (IEditorPart)Platform.getAdapterManager().getAdapter(object, IEditorPart.class);
        if (activeEditor instanceof IMultiDiagramEditor) {
            activeEditor = ((IMultiDiagramEditor)activeEditor).getActiveEditor();
        }
        if (activeEditor instanceof DiagramEditor) {
            return (DiagramEditor)activeEditor;
        }
        return null;
    }

    public Injector createInjector(Module defaultModule) {
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{defaultModule}).with(new Module[]{new PapyrusLayoutModule()})});
    }

    public static class PapyrusLayoutModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(IDiagramLayoutConnector.class).to(PapyrusDiagramLayoutConnector.class);
            binder.bind(ILayoutConfigurationStore.Provider.class).to(GmfLayoutConfigurationStore.Provider.class);
        }
    }
}

